<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XRemoteDestination StructType
 * @subpackage Structs
 */
class XRemoteDestination extends AbstractStructBase
{
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $destination;
    /**
     * The answerTooSoonTimer
     * Meta informations extracted from the WSDL
     * - default: 1500
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $answerTooSoonTimer;
    /**
     * The answerTooLateTimer
     * Meta informations extracted from the WSDL
     * - default: 19000
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $answerTooLateTimer;
    /**
     * The delayBeforeRingingCell
     * Meta informations extracted from the WSDL
     * - default: 4000
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $delayBeforeRingingCell;
    /**
     * The remoteDestinationProfileName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $remoteDestinationProfileName;
    /**
     * The dualModeDeviceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $dualModeDeviceName;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The isMobilePhone
     * Meta informations extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isMobilePhone;
    /**
     * The enableMobileConnect
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $enableMobileConnect;
    /**
     * The lineAssociations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var LineAssociations
     */
    public $lineAssociations;
    /**
     * The timeZone
     * Meta informations extracted from the WSDL
     * - default: GMT
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $timeZone;
    /**
     * The todAccessName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $todAccessName;
    /**
     * The mobileSmartClientName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is not applicable for dualmode phones
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $mobileSmartClientName;
    /**
     * The mobilityProfileName
     * Meta informations extracted from the WSDL
     * - documentation: This tag is applicable only to CUMC devices.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $mobilityProfileName;
    /**
     * Constructor method for XRemoteDestination
     * @uses XRemoteDestination::setDestination()
     * @uses XRemoteDestination::setAnswerTooSoonTimer()
     * @uses XRemoteDestination::setAnswerTooLateTimer()
     * @uses XRemoteDestination::setDelayBeforeRingingCell()
     * @uses XRemoteDestination::setRemoteDestinationProfileName()
     * @uses XRemoteDestination::setDualModeDeviceName()
     * @uses XRemoteDestination::setName()
     * @uses XRemoteDestination::setIsMobilePhone()
     * @uses XRemoteDestination::setEnableMobileConnect()
     * @uses XRemoteDestination::setLineAssociations()
     * @uses XRemoteDestination::setTimeZone()
     * @uses XRemoteDestination::setTodAccessName()
     * @uses XRemoteDestination::setMobileSmartClientName()
     * @uses XRemoteDestination::setMobilityProfileName()
     * @param string $destination
     * @param string $answerTooSoonTimer
     * @param string $answerTooLateTimer
     * @param string $delayBeforeRingingCell
     * @param XFkType $remoteDestinationProfileName
     * @param XFkType $dualModeDeviceName
     * @param string $name
     * @param string $isMobilePhone
     * @param string $enableMobileConnect
     * @param LineAssociations $lineAssociations
     * @param string $timeZone
     * @param XFkType $todAccessName
     * @param XFkType $mobileSmartClientName
     * @param XFkType $mobilityProfileName
     */
    public function __construct($destination = null, $answerTooSoonTimer = '1500', $answerTooLateTimer = '19000', $delayBeforeRingingCell = '4000', XFkType $remoteDestinationProfileName = null, XFkType $dualModeDeviceName = null, $name = null, $isMobilePhone = false, $enableMobileConnect = true, LineAssociations $lineAssociations = null, $timeZone = 'GMT', XFkType $todAccessName = null, XFkType $mobileSmartClientName = null, XFkType $mobilityProfileName = null)
    {
        $this
            ->setDestination($destination)
            ->setAnswerTooSoonTimer($answerTooSoonTimer)
            ->setAnswerTooLateTimer($answerTooLateTimer)
            ->setDelayBeforeRingingCell($delayBeforeRingingCell)
            ->setRemoteDestinationProfileName($remoteDestinationProfileName)
            ->setDualModeDeviceName($dualModeDeviceName)
            ->setName($name)
            ->setIsMobilePhone($isMobilePhone)
            ->setEnableMobileConnect($enableMobileConnect)
            ->setLineAssociations($lineAssociations)
            ->setTimeZone($timeZone)
            ->setTodAccessName($todAccessName)
            ->setMobileSmartClientName($mobileSmartClientName)
            ->setMobilityProfileName($mobilityProfileName);
    }
    /**
     * Get destination value
     * @return string
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return XRemoteDestination
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get answerTooSoonTimer value
     * @return string
     */
    public function getAnswerTooSoonTimer()
    {
        return $this->answerTooSoonTimer;
    }
    /**
     * Set answerTooSoonTimer value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooSoonTimer
     * @return XRemoteDestination
     */
    public function setAnswerTooSoonTimer($answerTooSoonTimer = '1500')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($answerTooSoonTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $answerTooSoonTimer, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooSoonTimer = $answerTooSoonTimer;
        return $this;
    }
    /**
     * Get answerTooLateTimer value
     * @return string
     */
    public function getAnswerTooLateTimer()
    {
        return $this->answerTooLateTimer;
    }
    /**
     * Set answerTooLateTimer value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answerTooLateTimer
     * @return XRemoteDestination
     */
    public function setAnswerTooLateTimer($answerTooLateTimer = '19000')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($answerTooLateTimer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $answerTooLateTimer, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->answerTooLateTimer = $answerTooLateTimer;
        return $this;
    }
    /**
     * Get delayBeforeRingingCell value
     * @return string
     */
    public function getDelayBeforeRingingCell()
    {
        return $this->delayBeforeRingingCell;
    }
    /**
     * Set delayBeforeRingingCell value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $delayBeforeRingingCell
     * @return XRemoteDestination
     */
    public function setDelayBeforeRingingCell($delayBeforeRingingCell = '4000')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($delayBeforeRingingCell)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $delayBeforeRingingCell, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->delayBeforeRingingCell = $delayBeforeRingingCell;
        return $this;
    }
    /**
     * Get remoteDestinationProfileName value
     * @return XFkType
     */
    public function getRemoteDestinationProfileName()
    {
        return $this->remoteDestinationProfileName;
    }
    /**
     * Set remoteDestinationProfileName value
     * @param XFkType $remoteDestinationProfileName
     * @return XRemoteDestination
     */
    public function setRemoteDestinationProfileName(XFkType $remoteDestinationProfileName = null)
    {
        $this->remoteDestinationProfileName = $remoteDestinationProfileName;
        return $this;
    }
    /**
     * Get dualModeDeviceName value
     * @return XFkType
     */
    public function getDualModeDeviceName()
    {
        return $this->dualModeDeviceName;
    }
    /**
     * Set dualModeDeviceName value
     * @param XFkType $dualModeDeviceName
     * @return XRemoteDestination
     */
    public function setDualModeDeviceName(XFkType $dualModeDeviceName = null)
    {
        $this->dualModeDeviceName = $dualModeDeviceName;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XRemoteDestination
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get isMobilePhone value
     * @return string|null
     */
    public function getIsMobilePhone()
    {
        return $this->isMobilePhone;
    }
    /**
     * Set isMobilePhone value
     * @param string $isMobilePhone
     * @return XRemoteDestination
     */
    public function setIsMobilePhone($isMobilePhone = false)
    {
        // validation for constraint: pattern
        if (is_scalar($isMobilePhone) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isMobilePhone, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isMobilePhone) && !is_string($isMobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isMobilePhone)), __LINE__);
        }
        $this->isMobilePhone = $isMobilePhone;
        return $this;
    }
    /**
     * Get enableMobileConnect value
     * @return string|null
     */
    public function getEnableMobileConnect()
    {
        return $this->enableMobileConnect;
    }
    /**
     * Set enableMobileConnect value
     * @param string $enableMobileConnect
     * @return XRemoteDestination
     */
    public function setEnableMobileConnect($enableMobileConnect = true)
    {
        // validation for constraint: pattern
        if (is_scalar($enableMobileConnect) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($enableMobileConnect, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enableMobileConnect) && !is_string($enableMobileConnect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enableMobileConnect)), __LINE__);
        }
        $this->enableMobileConnect = $enableMobileConnect;
        return $this;
    }
    /**
     * Get lineAssociations value
     * @return LineAssociations|null
     */
    public function getLineAssociations()
    {
        return $this->lineAssociations;
    }
    /**
     * Set lineAssociations value
     * @param LineAssociations $lineAssociations
     * @return XRemoteDestination
     */
    public function setLineAssociations(LineAssociations $lineAssociations = null)
    {
        $this->lineAssociations = $lineAssociations;
        return $this;
    }
    /**
     * Get timeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * Set timeZone value
     * @uses XTimeZone::valueIsValid()
     * @uses XTimeZone::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $timeZone
     * @return XRemoteDestination
     */
    public function setTimeZone($timeZone = 'GMT')
    {
        // validation for constraint: enumeration
        if (!XTimeZone::valueIsValid($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $timeZone, implode(', ', XTimeZone::getValidValues())), __LINE__);
        }
        $this->timeZone = $timeZone;
        return $this;
    }
    /**
     * Get todAccessName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getTodAccessName()
    {
        return isset($this->todAccessName) ? $this->todAccessName : null;
    }
    /**
     * Set todAccessName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $todAccessName
     * @return XRemoteDestination
     */
    public function setTodAccessName(XFkType $todAccessName = null)
    {
        if (is_null($todAccessName) || (is_array($todAccessName) && empty($todAccessName))) {
            unset($this->todAccessName);
        } else {
            $this->todAccessName = $todAccessName;
        }
        return $this;
    }
    /**
     * Get mobileSmartClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMobileSmartClientName()
    {
        return isset($this->mobileSmartClientName) ? $this->mobileSmartClientName : null;
    }
    /**
     * Set mobileSmartClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $mobileSmartClientName
     * @return XRemoteDestination
     */
    public function setMobileSmartClientName(XFkType $mobileSmartClientName = null)
    {
        if (is_null($mobileSmartClientName) || (is_array($mobileSmartClientName) && empty($mobileSmartClientName))) {
            unset($this->mobileSmartClientName);
        } else {
            $this->mobileSmartClientName = $mobileSmartClientName;
        }
        return $this;
    }
    /**
     * Get mobilityProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getMobilityProfileName()
    {
        return isset($this->mobilityProfileName) ? $this->mobilityProfileName : null;
    }
    /**
     * Set mobilityProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $mobilityProfileName
     * @return XRemoteDestination
     */
    public function setMobilityProfileName(XFkType $mobilityProfileName = null)
    {
        if (is_null($mobilityProfileName) || (is_array($mobilityProfileName) && empty($mobilityProfileName))) {
            unset($this->mobilityProfileName);
        } else {
            $this->mobilityProfileName = $mobilityProfileName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XRemoteDestination
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
