<?php
/**
 * This class stands for XQSIGVariant EnumType
 * @subpackage Enumerations
 */
class XQSIGVariant
{
    /**
     * Constant for value 'No Changes'
     * @return string 'No Changes'
     */
    const VALUE_NO_CHANGES = 'No Changes';
    /**
     * Constant for value 'ECMA'
     * @return string 'ECMA'
     */
    const VALUE_ECMA = 'ECMA';
    /**
     * Constant for value 'ISO'
     * @return string 'ISO'
     */
    const VALUE_ISO = 'ISO';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_CHANGES
     * @uses self::VALUE_ECMA
     * @uses self::VALUE_ISO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_CHANGES,
            self::VALUE_ECMA,
            self::VALUE_ISO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
