<?php
/**
 * This class stands for XProductConfig EnumType
 * @subpackage Enumerations
 */
class XProductConfig
{
    /**
     * Constant for value 'CallingPartySelection'
     * @return string 'CallingPartySelection'
     */
    const VALUE_CALLING_PARTY_SELECTION = 'CallingPartySelection';
    /**
     * Constant for value 'ClockReference'
     * @return string 'ClockReference'
     */
    const VALUE_CLOCK_REFERENCE = 'ClockReference';
    /**
     * Constant for value 'CSUParam'
     * @return string 'CSUParam'
     */
    const VALUE_CSUPARAM = 'CSUParam';
    /**
     * Constant for value 'DeviceProtocol'
     * @return string 'DeviceProtocol'
     */
    const VALUE_DEVICE_PROTOCOL = 'DeviceProtocol';
    /**
     * Constant for value 'DigitSending'
     * @return string 'DigitSending'
     */
    const VALUE_DIGIT_SENDING = 'DigitSending';
    /**
     * Constant for value 'PriProtocolT1'
     * @return string 'PriProtocolT1'
     */
    const VALUE_PRI_PROTOCOL_T_1 = 'PriProtocolT1';
    /**
     * Constant for value 'ProtocolSide'
     * @return string 'ProtocolSide'
     */
    const VALUE_PROTOCOL_SIDE = 'ProtocolSide';
    /**
     * Constant for value 'StartDialProtocol'
     * @return string 'StartDialProtocol'
     */
    const VALUE_START_DIAL_PROTOCOL = 'StartDialProtocol';
    /**
     * Constant for value 'Trunk'
     * @return string 'Trunk'
     */
    const VALUE_TRUNK = 'Trunk';
    /**
     * Constant for value 'ZeroSuppressionPri'
     * @return string 'ZeroSuppressionPri'
     */
    const VALUE_ZERO_SUPPRESSION_PRI = 'ZeroSuppressionPri';
    /**
     * Constant for value 'ZeroSuppressionT1'
     * @return string 'ZeroSuppressionT1'
     */
    const VALUE_ZERO_SUPPRESSION_T_1 = 'ZeroSuppressionT1';
    /**
     * Constant for value 'FramingPRI'
     * @return string 'FramingPRI'
     */
    const VALUE_FRAMING_PRI = 'FramingPRI';
    /**
     * Constant for value 'FramingT1'
     * @return string 'FramingT1'
     */
    const VALUE_FRAMING_T_1 = 'FramingT1';
    /**
     * Constant for value 'ZeroSuppressionE1'
     * @return string 'ZeroSuppressionE1'
     */
    const VALUE_ZERO_SUPPRESSION_E_1 = 'ZeroSuppressionE1';
    /**
     * Constant for value 'MGCPCompatibleModules'
     * @return string 'MGCPCompatibleModules'
     */
    const VALUE_MGCPCOMPATIBLE_MODULES = 'MGCPCompatibleModules';
    /**
     * Constant for value 'MGCPSlotModuleMap'
     * @return string 'MGCPSlotModuleMap'
     */
    const VALUE_MGCPSLOT_MODULE_MAP = 'MGCPSlotModuleMap';
    /**
     * Constant for value 'MGCPModuleVicMap'
     * @return string 'MGCPModuleVicMap'
     */
    const VALUE_MGCPMODULE_VIC_MAP = 'MGCPModuleVicMap';
    /**
     * Constant for value 'PriProtocolE1'
     * @return string 'PriProtocolE1'
     */
    const VALUE_PRI_PROTOCOL_E_1 = 'PriProtocolE1';
    /**
     * Constant for value 'NetworkLocale'
     * @return string 'NetworkLocale'
     */
    const VALUE_NETWORK_LOCALE = 'NetworkLocale';
    /**
     * Constant for value 'Encode'
     * @return string 'Encode'
     */
    const VALUE_ENCODE = 'Encode';
    /**
     * Constant for value 'BriProtocol'
     * @return string 'BriProtocol'
     */
    const VALUE_BRI_PROTOCOL = 'BriProtocol';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CALLING_PARTY_SELECTION
     * @uses self::VALUE_CLOCK_REFERENCE
     * @uses self::VALUE_CSUPARAM
     * @uses self::VALUE_DEVICE_PROTOCOL
     * @uses self::VALUE_DIGIT_SENDING
     * @uses self::VALUE_PRI_PROTOCOL_T_1
     * @uses self::VALUE_PROTOCOL_SIDE
     * @uses self::VALUE_START_DIAL_PROTOCOL
     * @uses self::VALUE_TRUNK
     * @uses self::VALUE_ZERO_SUPPRESSION_PRI
     * @uses self::VALUE_ZERO_SUPPRESSION_T_1
     * @uses self::VALUE_FRAMING_PRI
     * @uses self::VALUE_FRAMING_T_1
     * @uses self::VALUE_ZERO_SUPPRESSION_E_1
     * @uses self::VALUE_MGCPCOMPATIBLE_MODULES
     * @uses self::VALUE_MGCPSLOT_MODULE_MAP
     * @uses self::VALUE_MGCPMODULE_VIC_MAP
     * @uses self::VALUE_PRI_PROTOCOL_E_1
     * @uses self::VALUE_NETWORK_LOCALE
     * @uses self::VALUE_ENCODE
     * @uses self::VALUE_BRI_PROTOCOL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CALLING_PARTY_SELECTION,
            self::VALUE_CLOCK_REFERENCE,
            self::VALUE_CSUPARAM,
            self::VALUE_DEVICE_PROTOCOL,
            self::VALUE_DIGIT_SENDING,
            self::VALUE_PRI_PROTOCOL_T_1,
            self::VALUE_PROTOCOL_SIDE,
            self::VALUE_START_DIAL_PROTOCOL,
            self::VALUE_TRUNK,
            self::VALUE_ZERO_SUPPRESSION_PRI,
            self::VALUE_ZERO_SUPPRESSION_T_1,
            self::VALUE_FRAMING_PRI,
            self::VALUE_FRAMING_T_1,
            self::VALUE_ZERO_SUPPRESSION_E_1,
            self::VALUE_MGCPCOMPATIBLE_MODULES,
            self::VALUE_MGCPSLOT_MODULE_MAP,
            self::VALUE_MGCPMODULE_VIC_MAP,
            self::VALUE_PRI_PROTOCOL_E_1,
            self::VALUE_NETWORK_LOCALE,
            self::VALUE_ENCODE,
            self::VALUE_BRI_PROTOCOL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
