<?php
/**
 * This class stands for XPluginUsage EnumType
 * @subpackage Enumerations
 */
class XPluginUsage
{
    /**
     * Constant for value 'Application Menu'
     * @return string 'Application Menu'
     */
    const VALUE_APPLICATION_MENU = 'Application Menu';
    /**
     * Constant for value 'Installation'
     * @return string 'Installation'
     */
    const VALUE_INSTALLATION = 'Installation';
    /**
     * Constant for value 'User Menu'
     * @return string 'User Menu'
     */
    const VALUE_USER_MENU = 'User Menu';
    /**
     * Constant for value 'Telecaster Menu'
     * @return string 'Telecaster Menu'
     */
    const VALUE_TELECASTER_MENU = 'Telecaster Menu';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_APPLICATION_MENU
     * @uses self::VALUE_INSTALLATION
     * @uses self::VALUE_USER_MENU
     * @uses self::VALUE_TELECASTER_MENU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_APPLICATION_MENU,
            self::VALUE_INSTALLATION,
            self::VALUE_USER_MENU,
            self::VALUE_TELECASTER_MENU,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
