<?php
/**
 * This class stands for XPhoneService EnumType
 * @subpackage Enumerations
 */
class XPhoneService
{
    /**
     * Constant for value 'Standard IP Phone Service'
     * @return string 'Standard IP Phone Service'
     */
    const VALUE_STANDARD_IP_PHONE_SERVICE = 'Standard IP Phone Service';
    /**
     * Constant for value 'Directories'
     * @return string 'Directories'
     */
    const VALUE_DIRECTORIES = 'Directories';
    /**
     * Constant for value 'Messages'
     * @return string 'Messages'
     */
    const VALUE_MESSAGES = 'Messages';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD_IP_PHONE_SERVICE
     * @uses self::VALUE_DIRECTORIES
     * @uses self::VALUE_MESSAGES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD_IP_PHONE_SERVICE,
            self::VALUE_DIRECTORIES,
            self::VALUE_MESSAGES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
