<?php
/**
 * This class stands for XPhoneCategory EnumType
 * @subpackage Enumerations
 */
class XPhoneCategory
{
    /**
     * Constant for value 'Desk Phone'
     * @return string 'Desk Phone'
     */
    const VALUE_DESK_PHONE = 'Desk Phone';
    /**
     * Constant for value 'Mobile Device'
     * @return string 'Mobile Device'
     */
    const VALUE_MOBILE_DEVICE = 'Mobile Device';
    /**
     * Constant for value 'Profile'
     * @return string 'Profile'
     */
    const VALUE_PROFILE = 'Profile';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DESK_PHONE
     * @uses self::VALUE_MOBILE_DEVICE
     * @uses self::VALUE_PROFILE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DESK_PHONE,
            self::VALUE_MOBILE_DEVICE,
            self::VALUE_PROFILE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
