<?php
/**
 * This class stands for XOperator EnumType
 * @subpackage Enumerations
 */
class XOperator
{
    /**
     * Constant for value 'NOT-SELECTED'
     * @return string 'NOT-SELECTED'
     */
    const VALUE_NOT_SELECTED = 'NOT-SELECTED';
    /**
     * Constant for value 'EXISTS'
     * @return string 'EXISTS'
     */
    const VALUE_EXISTS = 'EXISTS';
    /**
     * Constant for value 'DOES-NOT-EXIST'
     * @return string 'DOES-NOT-EXIST'
     */
    const VALUE_DOES_NOT_EXIST = 'DOES-NOT-EXIST';
    /**
     * Constant for value '=='
     * @return string '=='
     */
    const VALUE_ = '==';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_SELECTED
     * @uses self::VALUE_EXISTS
     * @uses self::VALUE_DOES_NOT_EXIST
     * @uses self::VALUE_
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_SELECTED,
            self::VALUE_EXISTS,
            self::VALUE_DOES_NOT_EXIST,
            self::VALUE_,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
