<?php
/**
 * This class stands for XMediaPayload EnumType
 * @subpackage Enumerations
 */
class XMediaPayload
{
    /**
     * Constant for value 'G711 a-law 64K'
     * @return string 'G711 a-law 64K'
     */
    const VALUE_G_711_A_LAW_64_K = 'G711 a-law 64K';
    /**
     * Constant for value 'G711 u-law 64K'
     * @return string 'G711 u-law 64K'
     */
    const VALUE_G_711_U_LAW_64_K = 'G711 u-law 64K';
    /**
     * Constant for value 'G723'
     * @return string 'G723'
     */
    const VALUE_G_723 = 'G723';
    /**
     * Constant for value 'G729'
     * @return string 'G729'
     */
    const VALUE_G_729 = 'G729';
    /**
     * Constant for value 'G729AnnexA'
     * @return string 'G729AnnexA'
     */
    const VALUE_G_729_ANNEX_A = 'G729AnnexA';
    /**
     * Constant for value 'G729AnnexB'
     * @return string 'G729AnnexB'
     */
    const VALUE_G_729_ANNEX_B = 'G729AnnexB';
    /**
     * Constant for value 'G729AnnexA-AnnexB'
     * @return string 'G729AnnexA-AnnexB'
     */
    const VALUE_G_729_ANNEX_A_ANNEX_B = 'G729AnnexA-AnnexB';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_G_711_A_LAW_64_K
     * @uses self::VALUE_G_711_U_LAW_64_K
     * @uses self::VALUE_G_723
     * @uses self::VALUE_G_729
     * @uses self::VALUE_G_729_ANNEX_A
     * @uses self::VALUE_G_729_ANNEX_B
     * @uses self::VALUE_G_729_ANNEX_A_ANNEX_B
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_G_711_A_LAW_64_K,
            self::VALUE_G_711_U_LAW_64_K,
            self::VALUE_G_723,
            self::VALUE_G_729,
            self::VALUE_G_729_ANNEX_A,
            self::VALUE_G_729_ANNEX_B,
            self::VALUE_G_729_ANNEX_A_ANNEX_B,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
