<?php
/**
 * This class stands for XLicensingState EnumType
 * @subpackage Enumerations
 */
class XLicensingState
{
    /**
     * Constant for value 'Demo'
     * @return string 'Demo'
     */
    const VALUE_DEMO = 'Demo';
    /**
     * Constant for value 'compliant'
     * @return string 'compliant'
     */
    const VALUE_COMPLIANT = 'compliant';
    /**
     * Constant for value 'Overage'
     * @return string 'Overage'
     */
    const VALUE_OVERAGE = 'Overage';
    /**
     * Constant for value 'No Contact'
     * @return string 'No Contact'
     */
    const VALUE_NO_CONTACT = 'No Contact';
    /**
     * Constant for value 'Security Failure'
     * @return string 'Security Failure'
     */
    const VALUE_SECURITY_FAILURE = 'Security Failure';
    /**
     * Constant for value 'No Provisioning'
     * @return string 'No Provisioning'
     */
    const VALUE_NO_PROVISIONING = 'No Provisioning';
    /**
     * Constant for value 'Grace'
     * @return string 'Grace'
     */
    const VALUE_GRACE = 'Grace';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEMO
     * @uses self::VALUE_COMPLIANT
     * @uses self::VALUE_OVERAGE
     * @uses self::VALUE_NO_CONTACT
     * @uses self::VALUE_SECURITY_FAILURE
     * @uses self::VALUE_NO_PROVISIONING
     * @uses self::VALUE_GRACE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEMO,
            self::VALUE_COMPLIANT,
            self::VALUE_OVERAGE,
            self::VALUE_NO_CONTACT,
            self::VALUE_SECURITY_FAILURE,
            self::VALUE_NO_PROVISIONING,
            self::VALUE_GRACE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
