<?php
/**
 * This class stands for XLicensingMode EnumType
 * @subpackage Enumerations
 */
class XLicensingMode
{
    /**
     * Constant for value 'System Capacity Licensing of Nodes in the cluster'
     * @return string 'System Capacity Licensing of Nodes in the cluster'
     */
    const VALUE_SYSTEM_CAPACITY_LICENSING_OF_NODES_IN_THE_CLUSTER = 'System Capacity Licensing of Nodes in the cluster';
    /**
     * Constant for value 'System Utilization Licensing Per DLU Consumption'
     * @return string 'System Utilization Licensing Per DLU Consumption'
     */
    const VALUE_SYSTEM_UTILIZATION_LICENSING_PER_DLU_CONSUMPTION = 'System Utilization Licensing Per DLU Consumption';
    /**
     * Constant for value 'System Capability Licensing by Software & Version'
     * @return string 'System Capability Licensing by Software & Version'
     */
    const VALUE_SYSTEM_CAPABILITY_LICENSING_BY_SOFTWARE_VERSION = 'System Capability Licensing by Software & Version';
    /**
     * Constant for value 'System Utilization Licensing Per UCL Consumption'
     * @return string 'System Utilization Licensing Per UCL Consumption'
     */
    const VALUE_SYSTEM_UTILIZATION_LICENSING_PER_UCL_CONSUMPTION = 'System Utilization Licensing Per UCL Consumption';
    /**
     * Constant for value 'System Utilization Licensing Per User Consumption'
     * @return string 'System Utilization Licensing Per User Consumption'
     */
    const VALUE_SYSTEM_UTILIZATION_LICENSING_PER_USER_CONSUMPTION = 'System Utilization Licensing Per User Consumption';
    /**
     * Constant for value 'System Utilization Licensing for HCS deployments'
     * @return string 'System Utilization Licensing for HCS deployments'
     */
    const VALUE_SYSTEM_UTILIZATION_LICENSING_FOR_HCS_DEPLOYMENTS = 'System Utilization Licensing for HCS deployments';
    /**
     * Constant for value 'System Utilization Licensing for HCS Large Enterprise
     * deployments'
     * @return string 'System Utilization Licensing for HCS Large Enterprise deployments'
     */
    const VALUE_SYSTEM_UTILIZATION_LICENSING_FOR_HCS_LARGE_ENTERPRISE_DEPLOYMENTS = 'System Utilization Licensing for HCS Large Enterprise deployments';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SYSTEM_CAPACITY_LICENSING_OF_NODES_IN_THE_CLUSTER
     * @uses self::VALUE_SYSTEM_UTILIZATION_LICENSING_PER_DLU_CONSUMPTION
     * @uses self::VALUE_SYSTEM_CAPABILITY_LICENSING_BY_SOFTWARE_VERSION
     * @uses self::VALUE_SYSTEM_UTILIZATION_LICENSING_PER_UCL_CONSUMPTION
     * @uses self::VALUE_SYSTEM_UTILIZATION_LICENSING_PER_USER_CONSUMPTION
     * @uses self::VALUE_SYSTEM_UTILIZATION_LICENSING_FOR_HCS_DEPLOYMENTS
     * @uses self::VALUE_SYSTEM_UTILIZATION_LICENSING_FOR_HCS_LARGE_ENTERPRISE_DEPLOYMENTS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SYSTEM_CAPACITY_LICENSING_OF_NODES_IN_THE_CLUSTER,
            self::VALUE_SYSTEM_UTILIZATION_LICENSING_PER_DLU_CONSUMPTION,
            self::VALUE_SYSTEM_CAPABILITY_LICENSING_BY_SOFTWARE_VERSION,
            self::VALUE_SYSTEM_UTILIZATION_LICENSING_PER_UCL_CONSUMPTION,
            self::VALUE_SYSTEM_UTILIZATION_LICENSING_PER_USER_CONSUMPTION,
            self::VALUE_SYSTEM_UTILIZATION_LICENSING_FOR_HCS_DEPLOYMENTS,
            self::VALUE_SYSTEM_UTILIZATION_LICENSING_FOR_HCS_LARGE_ENTERPRISE_DEPLOYMENTS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
