<?php
/**
 * This class stands for XIPMATarget EnumType
 * @subpackage Enumerations
 */
class XIPMATarget
{
    /**
     * Constant for value 'Manager/Assistant'
     * @return string 'Manager/Assistant'
     */
    const VALUE_MANAGER_ASSISTANT = 'Manager/Assistant';
    /**
     * Constant for value 'Diverted'
     * @return string 'Diverted'
     */
    const VALUE_DIVERTED = 'Diverted';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MANAGER_ASSISTANT
     * @uses self::VALUE_DIVERTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MANAGER_ASSISTANT,
            self::VALUE_DIVERTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
