<?php
/**
 * This class stands for XGroupVersionStamp EnumType
 * @subpackage Enumerations
 */
class XGroupVersionStamp
{
    /**
     * Constant for value 'Generic Group'
     * @return string 'Generic Group'
     */
    const VALUE_GENERIC_GROUP = 'Generic Group';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GENERIC_GROUP
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GENERIC_GROUP,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
