<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XGatewayEndpointDigitalBri StructType
 * @subpackage Structs
 */
class XGatewayEndpointDigitalBri extends AbstractStructBase
{
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $index;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The device name,using only URL-friendly characters
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 128
     * @var string
     */
    public $name;
    /**
     * The product
     * Meta informations extracted from the WSDL
     * - documentation: Product ID string. read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $product;
    /**
     * The class
     * Meta informations extracted from the WSDL
     * - documentation: Class ID string. Class information is read-only except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $class;
    /**
     * The protocol
     * Meta informations extracted from the WSDL
     * - documentation: Protocol option is read-only,except when creating a device.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $protocol;
    /**
     * The protocolSide
     * Meta informations extracted from the WSDL
     * - default: User
     * - documentation: Side information is read-only except when creating a device
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $protocolSide;
    /**
     * The callingSearchSpaceName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $callingSearchSpaceName;
    /**
     * The devicePoolName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $devicePoolName;
    /**
     * The commonDeviceConfigName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $commonDeviceConfigName;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $locationName;
    /**
     * The mediaResourceListName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $mediaResourceListName;
    /**
     * The automatedAlternateRoutingCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $automatedAlternateRoutingCssName;
    /**
     * The aarNeighborhoodName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $aarNeighborhoodName;
    /**
     * The cgpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $cgpnTransformationCssName;
    /**
     * The geoLocationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationName;
    /**
     * The redirectInboundNumberIe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectInboundNumberIe;
    /**
     * The briProtocol
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $briProtocol;
    /**
     * The calledPlan
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $calledPlan;
    /**
     * The calledPri
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $calledPri;
    /**
     * The callerIdDn
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - maxLength: 255
     * @var string
     */
    public $callerIdDn;
    /**
     * The callingPartySelection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $callingPartySelection;
    /**
     * The callingPlan
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $callingPlan;
    /**
     * The callingPri
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $callingPri;
    /**
     * The clockReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $clockReference;
    /**
     * The csuParam
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $csuParam;
    /**
     * The dChannelEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $dChannelEnable;
    /**
     * The channelSelectionOrder
     * Meta informations extracted from the WSDL
     * - default: Top Down
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $channelSelectionOrder;
    /**
     * The pcmType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $pcmType;
    /**
     * The firstDelay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $firstDelay;
    /**
     * The intraDelay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $intraDelay;
    /**
     * The redirectOutboundNumberIe
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $redirectOutboundNumberIe;
    /**
     * The numDigitsToStrip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $numDigitsToStrip;
    /**
     * The prefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $prefix;
    /**
     * The presentationBit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $presentationBit;
    /**
     * The sendRestart
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sendRestart;
    /**
     * The setupNonIsdnPi
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $setupNonIsdnPi;
    /**
     * The sigDigits
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var SigDigits
     */
    public $sigDigits;
    /**
     * The statusPoll
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $statusPoll;
    /**
     * The GClearEnable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $GClearEnable;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - documentation: Optional description of the device
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 128
     * @var string
     */
    public $description;
    /**
     * The networkLocation
     * Meta informations extracted from the WSDL
     * - default: Use System Default
     * - documentation: The new Device Destination for Trunk to Trunk Transfer and Drop Conference Feature is required for most gateways ,except FXS gateways and phones.Not Nullable.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkLocation;
    /**
     * The networkLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $networkLocale;
    /**
     * The vendorConfig
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XVendorConfig
     */
    public $vendorConfig;
    /**
     * The useDevicePoolCgpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCss;
    /**
     * The packetCaptureMode
     * Meta informations extracted from the WSDL
     * - default: None
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $packetCaptureMode;
    /**
     * The packetCaptureDuration
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $packetCaptureDuration;
    /**
     * The cdpnTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $cdpnTransformationCssName;
    /**
     * The useDevicePoolCdpnTransformCss
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCdpnTransformCss;
    /**
     * The geoLocationFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $geoLocationFilterName;
    /**
     * The nationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $nationalPrefix;
    /**
     * The internationalPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $internationalPrefix;
    /**
     * The unknownPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $unknownPrefix;
    /**
     * The subscriberPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $subscriberPrefix;
    /**
     * The nationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $nationalStripDigits;
    /**
     * The internationalStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $internationalStripDigits;
    /**
     * The unknownStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unknownStripDigits;
    /**
     * The subscriberStripDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $subscriberStripDigits;
    /**
     * The nationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $nationalTransformationCssName;
    /**
     * The internationalTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $internationalTransformationCssName;
    /**
     * The unknownTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $unknownTransformationCssName;
    /**
     * The subscriberTransformationCssName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $subscriberTransformationCssName;
    /**
     * The pstnAccess
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $pstnAccess;
    /**
     * The imeE164TransformationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $imeE164TransformationName;
    /**
     * The useDevicePoolCgpnTransformCssNatl
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssNatl;
    /**
     * The useDevicePoolCgpnTransformCssIntl
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssIntl;
    /**
     * The useDevicePoolCgpnTransformCssUnkn
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssUnkn;
    /**
     * The useDevicePoolCgpnTransformCssSubs
     * Meta informations extracted from the WSDL
     * - default: true
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useDevicePoolCgpnTransformCssSubs;
    /**
     * The ctiid
     * @var int
     */
    public $ctiid;
    /**
     * Constructor method for XGatewayEndpointDigitalBri
     * @uses XGatewayEndpointDigitalBri::setIndex()
     * @uses XGatewayEndpointDigitalBri::setName()
     * @uses XGatewayEndpointDigitalBri::setProduct()
     * @uses XGatewayEndpointDigitalBri::setClass()
     * @uses XGatewayEndpointDigitalBri::setProtocol()
     * @uses XGatewayEndpointDigitalBri::setProtocolSide()
     * @uses XGatewayEndpointDigitalBri::setCallingSearchSpaceName()
     * @uses XGatewayEndpointDigitalBri::setDevicePoolName()
     * @uses XGatewayEndpointDigitalBri::setCommonDeviceConfigName()
     * @uses XGatewayEndpointDigitalBri::setLocationName()
     * @uses XGatewayEndpointDigitalBri::setMediaResourceListName()
     * @uses XGatewayEndpointDigitalBri::setAutomatedAlternateRoutingCssName()
     * @uses XGatewayEndpointDigitalBri::setAarNeighborhoodName()
     * @uses XGatewayEndpointDigitalBri::setCgpnTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setGeoLocationName()
     * @uses XGatewayEndpointDigitalBri::setRedirectInboundNumberIe()
     * @uses XGatewayEndpointDigitalBri::setBriProtocol()
     * @uses XGatewayEndpointDigitalBri::setCalledPlan()
     * @uses XGatewayEndpointDigitalBri::setCalledPri()
     * @uses XGatewayEndpointDigitalBri::setCallerIdDn()
     * @uses XGatewayEndpointDigitalBri::setCallingPartySelection()
     * @uses XGatewayEndpointDigitalBri::setCallingPlan()
     * @uses XGatewayEndpointDigitalBri::setCallingPri()
     * @uses XGatewayEndpointDigitalBri::setClockReference()
     * @uses XGatewayEndpointDigitalBri::setCsuParam()
     * @uses XGatewayEndpointDigitalBri::setDChannelEnable()
     * @uses XGatewayEndpointDigitalBri::setChannelSelectionOrder()
     * @uses XGatewayEndpointDigitalBri::setPcmType()
     * @uses XGatewayEndpointDigitalBri::setFirstDelay()
     * @uses XGatewayEndpointDigitalBri::setIntraDelay()
     * @uses XGatewayEndpointDigitalBri::setRedirectOutboundNumberIe()
     * @uses XGatewayEndpointDigitalBri::setNumDigitsToStrip()
     * @uses XGatewayEndpointDigitalBri::setPrefix()
     * @uses XGatewayEndpointDigitalBri::setPresentationBit()
     * @uses XGatewayEndpointDigitalBri::setSendRestart()
     * @uses XGatewayEndpointDigitalBri::setSetupNonIsdnPi()
     * @uses XGatewayEndpointDigitalBri::setSigDigits()
     * @uses XGatewayEndpointDigitalBri::setStatusPoll()
     * @uses XGatewayEndpointDigitalBri::setGClearEnable()
     * @uses XGatewayEndpointDigitalBri::setDescription()
     * @uses XGatewayEndpointDigitalBri::setNetworkLocation()
     * @uses XGatewayEndpointDigitalBri::setNetworkLocale()
     * @uses XGatewayEndpointDigitalBri::setVendorConfig()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCss()
     * @uses XGatewayEndpointDigitalBri::setPacketCaptureMode()
     * @uses XGatewayEndpointDigitalBri::setPacketCaptureDuration()
     * @uses XGatewayEndpointDigitalBri::setCdpnTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCdpnTransformCss()
     * @uses XGatewayEndpointDigitalBri::setGeoLocationFilterName()
     * @uses XGatewayEndpointDigitalBri::setNationalPrefix()
     * @uses XGatewayEndpointDigitalBri::setInternationalPrefix()
     * @uses XGatewayEndpointDigitalBri::setUnknownPrefix()
     * @uses XGatewayEndpointDigitalBri::setSubscriberPrefix()
     * @uses XGatewayEndpointDigitalBri::setNationalStripDigits()
     * @uses XGatewayEndpointDigitalBri::setInternationalStripDigits()
     * @uses XGatewayEndpointDigitalBri::setUnknownStripDigits()
     * @uses XGatewayEndpointDigitalBri::setSubscriberStripDigits()
     * @uses XGatewayEndpointDigitalBri::setNationalTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setInternationalTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setUnknownTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setSubscriberTransformationCssName()
     * @uses XGatewayEndpointDigitalBri::setPstnAccess()
     * @uses XGatewayEndpointDigitalBri::setImeE164TransformationName()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssNatl()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssIntl()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssUnkn()
     * @uses XGatewayEndpointDigitalBri::setUseDevicePoolCgpnTransformCssSubs()
     * @uses XGatewayEndpointDigitalBri::setCtiid()
     * @param string $index
     * @param string $name
     * @param string $product
     * @param string $class
     * @param string $protocol
     * @param string $protocolSide
     * @param XFkType $callingSearchSpaceName
     * @param XFkType $devicePoolName
     * @param XFkType $commonDeviceConfigName
     * @param XFkType $locationName
     * @param XFkType $mediaResourceListName
     * @param XFkType $automatedAlternateRoutingCssName
     * @param XFkType $aarNeighborhoodName
     * @param XFkType $cgpnTransformationCssName
     * @param XFkType $geoLocationName
     * @param string $redirectInboundNumberIe
     * @param string $briProtocol
     * @param string $calledPlan
     * @param string $calledPri
     * @param string $callerIdDn
     * @param string $callingPartySelection
     * @param string $callingPlan
     * @param string $callingPri
     * @param string $clockReference
     * @param string $csuParam
     * @param string $dChannelEnable
     * @param string $channelSelectionOrder
     * @param string $pcmType
     * @param string $firstDelay
     * @param string $intraDelay
     * @param string $redirectOutboundNumberIe
     * @param string $numDigitsToStrip
     * @param string $prefix
     * @param string $presentationBit
     * @param string $sendRestart
     * @param string $setupNonIsdnPi
     * @param SigDigits $sigDigits
     * @param string $statusPoll
     * @param string $gClearEnable
     * @param string $description
     * @param string $networkLocation
     * @param string $networkLocale
     * @param XVendorConfig $vendorConfig
     * @param string $useDevicePoolCgpnTransformCss
     * @param string $packetCaptureMode
     * @param string $packetCaptureDuration
     * @param XFkType $cdpnTransformationCssName
     * @param string $useDevicePoolCdpnTransformCss
     * @param XFkType $geoLocationFilterName
     * @param string $nationalPrefix
     * @param string $internationalPrefix
     * @param string $unknownPrefix
     * @param string $subscriberPrefix
     * @param string $nationalStripDigits
     * @param string $internationalStripDigits
     * @param string $unknownStripDigits
     * @param string $subscriberStripDigits
     * @param XFkType $nationalTransformationCssName
     * @param XFkType $internationalTransformationCssName
     * @param XFkType $unknownTransformationCssName
     * @param XFkType $subscriberTransformationCssName
     * @param string $pstnAccess
     * @param XFkType $imeE164TransformationName
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @param int $ctiid
     */
    public function __construct($index = '0', $name = null, $product = null, $class = null, $protocol = null, $protocolSide = 'User', XFkType $callingSearchSpaceName = null, XFkType $devicePoolName = null, XFkType $commonDeviceConfigName = null, XFkType $locationName = null, XFkType $mediaResourceListName = null, XFkType $automatedAlternateRoutingCssName = null, XFkType $aarNeighborhoodName = null, XFkType $cgpnTransformationCssName = null, XFkType $geoLocationName = null, $redirectInboundNumberIe = null, $briProtocol = null, $calledPlan = 'Cisco CallManager', $calledPri = 'Cisco CallManager', $callerIdDn = null, $callingPartySelection = null, $callingPlan = 'Cisco CallManager', $callingPri = 'Cisco CallManager', $clockReference = null, $csuParam = null, $dChannelEnable = null, $channelSelectionOrder = 'Top Down', $pcmType = null, $firstDelay = null, $intraDelay = null, $redirectOutboundNumberIe = null, $numDigitsToStrip = null, $prefix = null, $presentationBit = null, $sendRestart = null, $setupNonIsdnPi = null, SigDigits $sigDigits = null, $statusPoll = null, $gClearEnable = null, $description = null, $networkLocation = 'Use System Default', $networkLocale = null, XVendorConfig $vendorConfig = null, $useDevicePoolCgpnTransformCss = true, $packetCaptureMode = 'None', $packetCaptureDuration = '0', XFkType $cdpnTransformationCssName = null, $useDevicePoolCdpnTransformCss = true, XFkType $geoLocationFilterName = null, $nationalPrefix = null, $internationalPrefix = null, $unknownPrefix = null, $subscriberPrefix = null, $nationalStripDigits = null, $internationalStripDigits = null, $unknownStripDigits = null, $subscriberStripDigits = null, XFkType $nationalTransformationCssName = null, XFkType $internationalTransformationCssName = null, XFkType $unknownTransformationCssName = null, XFkType $subscriberTransformationCssName = null, $pstnAccess = true, XFkType $imeE164TransformationName = null, $useDevicePoolCgpnTransformCssNatl = true, $useDevicePoolCgpnTransformCssIntl = true, $useDevicePoolCgpnTransformCssUnkn = true, $useDevicePoolCgpnTransformCssSubs = true, $ctiid = null)
    {
        $this
            ->setIndex($index)
            ->setName($name)
            ->setProduct($product)
            ->setClass($class)
            ->setProtocol($protocol)
            ->setProtocolSide($protocolSide)
            ->setCallingSearchSpaceName($callingSearchSpaceName)
            ->setDevicePoolName($devicePoolName)
            ->setCommonDeviceConfigName($commonDeviceConfigName)
            ->setLocationName($locationName)
            ->setMediaResourceListName($mediaResourceListName)
            ->setAutomatedAlternateRoutingCssName($automatedAlternateRoutingCssName)
            ->setAarNeighborhoodName($aarNeighborhoodName)
            ->setCgpnTransformationCssName($cgpnTransformationCssName)
            ->setGeoLocationName($geoLocationName)
            ->setRedirectInboundNumberIe($redirectInboundNumberIe)
            ->setBriProtocol($briProtocol)
            ->setCalledPlan($calledPlan)
            ->setCalledPri($calledPri)
            ->setCallerIdDn($callerIdDn)
            ->setCallingPartySelection($callingPartySelection)
            ->setCallingPlan($callingPlan)
            ->setCallingPri($callingPri)
            ->setClockReference($clockReference)
            ->setCsuParam($csuParam)
            ->setDChannelEnable($dChannelEnable)
            ->setChannelSelectionOrder($channelSelectionOrder)
            ->setPcmType($pcmType)
            ->setFirstDelay($firstDelay)
            ->setIntraDelay($intraDelay)
            ->setRedirectOutboundNumberIe($redirectOutboundNumberIe)
            ->setNumDigitsToStrip($numDigitsToStrip)
            ->setPrefix($prefix)
            ->setPresentationBit($presentationBit)
            ->setSendRestart($sendRestart)
            ->setSetupNonIsdnPi($setupNonIsdnPi)
            ->setSigDigits($sigDigits)
            ->setStatusPoll($statusPoll)
            ->setGClearEnable($gClearEnable)
            ->setDescription($description)
            ->setNetworkLocation($networkLocation)
            ->setNetworkLocale($networkLocale)
            ->setVendorConfig($vendorConfig)
            ->setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss)
            ->setPacketCaptureMode($packetCaptureMode)
            ->setPacketCaptureDuration($packetCaptureDuration)
            ->setCdpnTransformationCssName($cdpnTransformationCssName)
            ->setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss)
            ->setGeoLocationFilterName($geoLocationFilterName)
            ->setNationalPrefix($nationalPrefix)
            ->setInternationalPrefix($internationalPrefix)
            ->setUnknownPrefix($unknownPrefix)
            ->setSubscriberPrefix($subscriberPrefix)
            ->setNationalStripDigits($nationalStripDigits)
            ->setInternationalStripDigits($internationalStripDigits)
            ->setUnknownStripDigits($unknownStripDigits)
            ->setSubscriberStripDigits($subscriberStripDigits)
            ->setNationalTransformationCssName($nationalTransformationCssName)
            ->setInternationalTransformationCssName($internationalTransformationCssName)
            ->setUnknownTransformationCssName($unknownTransformationCssName)
            ->setSubscriberTransformationCssName($subscriberTransformationCssName)
            ->setPstnAccess($pstnAccess)
            ->setImeE164TransformationName($imeE164TransformationName)
            ->setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl)
            ->setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl)
            ->setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn)
            ->setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs)
            ->setCtiid($ctiid);
    }
    /**
     * Get index value
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $index
     * @return XGatewayEndpointDigitalBri
     */
    public function setIndex($index = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($index)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $index, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->index = $index;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return XGatewayEndpointDigitalBri
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 128) || (is_array($name) && count($name) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get product value
     * @return string
     */
    public function getProduct()
    {
        return $this->product;
    }
    /**
     * Set product value
     * @uses XProduct::valueIsValid()
     * @uses XProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return XGatewayEndpointDigitalBri
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!XProduct::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $product, implode(', ', XProduct::getValidValues())), __LINE__);
        }
        $this->product = $product;
        return $this;
    }
    /**
     * Get class value
     * @return string
     */
    public function getClass()
    {
        return $this->class;
    }
    /**
     * Set class value
     * @uses XClass::valueIsValid()
     * @uses XClass::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $class
     * @return XGatewayEndpointDigitalBri
     */
    public function setClass($class = null)
    {
        // validation for constraint: enumeration
        if (!XClass::valueIsValid($class)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $class, implode(', ', XClass::getValidValues())), __LINE__);
        }
        $this->class = $class;
        return $this;
    }
    /**
     * Get protocol value
     * @return string
     */
    public function getProtocol()
    {
        return $this->protocol;
    }
    /**
     * Set protocol value
     * @uses XDeviceProtocol::valueIsValid()
     * @uses XDeviceProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocol
     * @return XGatewayEndpointDigitalBri
     */
    public function setProtocol($protocol = null)
    {
        // validation for constraint: enumeration
        if (!XDeviceProtocol::valueIsValid($protocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocol, implode(', ', XDeviceProtocol::getValidValues())), __LINE__);
        }
        $this->protocol = $protocol;
        return $this;
    }
    /**
     * Get protocolSide value
     * @return string
     */
    public function getProtocolSide()
    {
        return $this->protocolSide;
    }
    /**
     * Set protocolSide value
     * @uses XProtocolSide::valueIsValid()
     * @uses XProtocolSide::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $protocolSide
     * @return XGatewayEndpointDigitalBri
     */
    public function setProtocolSide($protocolSide = 'User')
    {
        // validation for constraint: enumeration
        if (!XProtocolSide::valueIsValid($protocolSide)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $protocolSide, implode(', ', XProtocolSide::getValidValues())), __LINE__);
        }
        $this->protocolSide = $protocolSide;
        return $this;
    }
    /**
     * Get callingSearchSpaceName value
     * @return XFkType
     */
    public function getCallingSearchSpaceName()
    {
        return $this->callingSearchSpaceName;
    }
    /**
     * Set callingSearchSpaceName value
     * @param XFkType $callingSearchSpaceName
     * @return XGatewayEndpointDigitalBri
     */
    public function setCallingSearchSpaceName(XFkType $callingSearchSpaceName = null)
    {
        $this->callingSearchSpaceName = $callingSearchSpaceName;
        return $this;
    }
    /**
     * Get devicePoolName value
     * @return XFkType
     */
    public function getDevicePoolName()
    {
        return $this->devicePoolName;
    }
    /**
     * Set devicePoolName value
     * @param XFkType $devicePoolName
     * @return XGatewayEndpointDigitalBri
     */
    public function setDevicePoolName(XFkType $devicePoolName = null)
    {
        $this->devicePoolName = $devicePoolName;
        return $this;
    }
    /**
     * Get commonDeviceConfigName value
     * @return XFkType
     */
    public function getCommonDeviceConfigName()
    {
        return $this->commonDeviceConfigName;
    }
    /**
     * Set commonDeviceConfigName value
     * @param XFkType $commonDeviceConfigName
     * @return XGatewayEndpointDigitalBri
     */
    public function setCommonDeviceConfigName(XFkType $commonDeviceConfigName = null)
    {
        $this->commonDeviceConfigName = $commonDeviceConfigName;
        return $this;
    }
    /**
     * Get locationName value
     * @return XFkType
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return XGatewayEndpointDigitalBri
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get mediaResourceListName value
     * @return XFkType
     */
    public function getMediaResourceListName()
    {
        return $this->mediaResourceListName;
    }
    /**
     * Set mediaResourceListName value
     * @param XFkType $mediaResourceListName
     * @return XGatewayEndpointDigitalBri
     */
    public function setMediaResourceListName(XFkType $mediaResourceListName = null)
    {
        $this->mediaResourceListName = $mediaResourceListName;
        return $this;
    }
    /**
     * Get automatedAlternateRoutingCssName value
     * @return XFkType
     */
    public function getAutomatedAlternateRoutingCssName()
    {
        return $this->automatedAlternateRoutingCssName;
    }
    /**
     * Set automatedAlternateRoutingCssName value
     * @param XFkType $automatedAlternateRoutingCssName
     * @return XGatewayEndpointDigitalBri
     */
    public function setAutomatedAlternateRoutingCssName(XFkType $automatedAlternateRoutingCssName = null)
    {
        $this->automatedAlternateRoutingCssName = $automatedAlternateRoutingCssName;
        return $this;
    }
    /**
     * Get aarNeighborhoodName value
     * @return XFkType
     */
    public function getAarNeighborhoodName()
    {
        return $this->aarNeighborhoodName;
    }
    /**
     * Set aarNeighborhoodName value
     * @param XFkType $aarNeighborhoodName
     * @return XGatewayEndpointDigitalBri
     */
    public function setAarNeighborhoodName(XFkType $aarNeighborhoodName = null)
    {
        $this->aarNeighborhoodName = $aarNeighborhoodName;
        return $this;
    }
    /**
     * Get cgpnTransformationCssName value
     * @return XFkType
     */
    public function getCgpnTransformationCssName()
    {
        return $this->cgpnTransformationCssName;
    }
    /**
     * Set cgpnTransformationCssName value
     * @param XFkType $cgpnTransformationCssName
     * @return XGatewayEndpointDigitalBri
     */
    public function setCgpnTransformationCssName(XFkType $cgpnTransformationCssName = null)
    {
        $this->cgpnTransformationCssName = $cgpnTransformationCssName;
        return $this;
    }
    /**
     * Get geoLocationName value
     * @return XFkType
     */
    public function getGeoLocationName()
    {
        return $this->geoLocationName;
    }
    /**
     * Set geoLocationName value
     * @param XFkType $geoLocationName
     * @return XGatewayEndpointDigitalBri
     */
    public function setGeoLocationName(XFkType $geoLocationName = null)
    {
        $this->geoLocationName = $geoLocationName;
        return $this;
    }
    /**
     * Get redirectInboundNumberIe value
     * @return string
     */
    public function getRedirectInboundNumberIe()
    {
        return $this->redirectInboundNumberIe;
    }
    /**
     * Set redirectInboundNumberIe value
     * @param string $redirectInboundNumberIe
     * @return XGatewayEndpointDigitalBri
     */
    public function setRedirectInboundNumberIe($redirectInboundNumberIe = null)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectInboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectInboundNumberIe, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectInboundNumberIe) && !is_string($redirectInboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectInboundNumberIe)), __LINE__);
        }
        $this->redirectInboundNumberIe = $redirectInboundNumberIe;
        return $this;
    }
    /**
     * Get briProtocol value
     * @return string
     */
    public function getBriProtocol()
    {
        return $this->briProtocol;
    }
    /**
     * Set briProtocol value
     * @uses XBriProtocol::valueIsValid()
     * @uses XBriProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $briProtocol
     * @return XGatewayEndpointDigitalBri
     */
    public function setBriProtocol($briProtocol = null)
    {
        // validation for constraint: enumeration
        if (!XBriProtocol::valueIsValid($briProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $briProtocol, implode(', ', XBriProtocol::getValidValues())), __LINE__);
        }
        $this->briProtocol = $briProtocol;
        return $this;
    }
    /**
     * Get calledPlan value
     * @return string
     */
    public function getCalledPlan()
    {
        return $this->calledPlan;
    }
    /**
     * Set calledPlan value
     * @uses XNumberingPlan::valueIsValid()
     * @uses XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPlan
     * @return XGatewayEndpointDigitalBri
     */
    public function setCalledPlan($calledPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XNumberingPlan::valueIsValid($calledPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPlan, implode(', ', XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPlan = $calledPlan;
        return $this;
    }
    /**
     * Get calledPri value
     * @return string
     */
    public function getCalledPri()
    {
        return $this->calledPri;
    }
    /**
     * Set calledPri value
     * @uses XPriOfNumber::valueIsValid()
     * @uses XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPri
     * @return XGatewayEndpointDigitalBri
     */
    public function setCalledPri($calledPri = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XPriOfNumber::valueIsValid($calledPri)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPri, implode(', ', XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPri = $calledPri;
        return $this;
    }
    /**
     * Get callerIdDn value
     * @return string
     */
    public function getCallerIdDn()
    {
        return $this->callerIdDn;
    }
    /**
     * Set callerIdDn value
     * @param string $callerIdDn
     * @return XGatewayEndpointDigitalBri
     */
    public function setCallerIdDn($callerIdDn = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($callerIdDn) && strlen($callerIdDn) > 255) || (is_array($callerIdDn) && count($callerIdDn) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($callerIdDn) ? strlen($callerIdDn) : count($callerIdDn)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($callerIdDn) && !is_string($callerIdDn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callerIdDn)), __LINE__);
        }
        $this->callerIdDn = $callerIdDn;
        return $this;
    }
    /**
     * Get callingPartySelection value
     * @return string
     */
    public function getCallingPartySelection()
    {
        return $this->callingPartySelection;
    }
    /**
     * Set callingPartySelection value
     * @uses XCallingPartySelection::valueIsValid()
     * @uses XCallingPartySelection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPartySelection
     * @return XGatewayEndpointDigitalBri
     */
    public function setCallingPartySelection($callingPartySelection = null)
    {
        // validation for constraint: enumeration
        if (!XCallingPartySelection::valueIsValid($callingPartySelection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPartySelection, implode(', ', XCallingPartySelection::getValidValues())), __LINE__);
        }
        $this->callingPartySelection = $callingPartySelection;
        return $this;
    }
    /**
     * Get callingPlan value
     * @return string
     */
    public function getCallingPlan()
    {
        return $this->callingPlan;
    }
    /**
     * Set callingPlan value
     * @uses XNumberingPlan::valueIsValid()
     * @uses XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPlan
     * @return XGatewayEndpointDigitalBri
     */
    public function setCallingPlan($callingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XNumberingPlan::valueIsValid($callingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPlan, implode(', ', XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->callingPlan = $callingPlan;
        return $this;
    }
    /**
     * Get callingPri value
     * @return string
     */
    public function getCallingPri()
    {
        return $this->callingPri;
    }
    /**
     * Set callingPri value
     * @uses XPriOfNumber::valueIsValid()
     * @uses XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $callingPri
     * @return XGatewayEndpointDigitalBri
     */
    public function setCallingPri($callingPri = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XPriOfNumber::valueIsValid($callingPri)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $callingPri, implode(', ', XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->callingPri = $callingPri;
        return $this;
    }
    /**
     * Get clockReference value
     * @return string
     */
    public function getClockReference()
    {
        return $this->clockReference;
    }
    /**
     * Set clockReference value
     * @uses XClockReference::valueIsValid()
     * @uses XClockReference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clockReference
     * @return XGatewayEndpointDigitalBri
     */
    public function setClockReference($clockReference = null)
    {
        // validation for constraint: enumeration
        if (!XClockReference::valueIsValid($clockReference)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $clockReference, implode(', ', XClockReference::getValidValues())), __LINE__);
        }
        $this->clockReference = $clockReference;
        return $this;
    }
    /**
     * Get csuParam value
     * @return string
     */
    public function getCsuParam()
    {
        return $this->csuParam;
    }
    /**
     * Set csuParam value
     * @uses XCSUParam::valueIsValid()
     * @uses XCSUParam::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $csuParam
     * @return XGatewayEndpointDigitalBri
     */
    public function setCsuParam($csuParam = null)
    {
        // validation for constraint: enumeration
        if (!XCSUParam::valueIsValid($csuParam)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $csuParam, implode(', ', XCSUParam::getValidValues())), __LINE__);
        }
        $this->csuParam = $csuParam;
        return $this;
    }
    /**
     * Get dChannelEnable value
     * @return string
     */
    public function getDChannelEnable()
    {
        return $this->dChannelEnable;
    }
    /**
     * Set dChannelEnable value
     * @param string $dChannelEnable
     * @return XGatewayEndpointDigitalBri
     */
    public function setDChannelEnable($dChannelEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($dChannelEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $dChannelEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($dChannelEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dChannelEnable) && !is_string($dChannelEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dChannelEnable)), __LINE__);
        }
        $this->dChannelEnable = $dChannelEnable;
        return $this;
    }
    /**
     * Get channelSelectionOrder value
     * @return string
     */
    public function getChannelSelectionOrder()
    {
        return $this->channelSelectionOrder;
    }
    /**
     * Set channelSelectionOrder value
     * @uses XTrunkSelectionOrder::valueIsValid()
     * @uses XTrunkSelectionOrder::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $channelSelectionOrder
     * @return XGatewayEndpointDigitalBri
     */
    public function setChannelSelectionOrder($channelSelectionOrder = 'Top Down')
    {
        // validation for constraint: enumeration
        if (!XTrunkSelectionOrder::valueIsValid($channelSelectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $channelSelectionOrder, implode(', ', XTrunkSelectionOrder::getValidValues())), __LINE__);
        }
        $this->channelSelectionOrder = $channelSelectionOrder;
        return $this;
    }
    /**
     * Get pcmType value
     * @return string
     */
    public function getPcmType()
    {
        return $this->pcmType;
    }
    /**
     * Set pcmType value
     * @uses XEncode::valueIsValid()
     * @uses XEncode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pcmType
     * @return XGatewayEndpointDigitalBri
     */
    public function setPcmType($pcmType = null)
    {
        // validation for constraint: enumeration
        if (!XEncode::valueIsValid($pcmType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pcmType, implode(', ', XEncode::getValidValues())), __LINE__);
        }
        $this->pcmType = $pcmType;
        return $this;
    }
    /**
     * Get firstDelay value
     * @return string
     */
    public function getFirstDelay()
    {
        return $this->firstDelay;
    }
    /**
     * Set firstDelay value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $firstDelay
     * @return XGatewayEndpointDigitalBri
     */
    public function setFirstDelay($firstDelay = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($firstDelay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $firstDelay, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->firstDelay = $firstDelay;
        return $this;
    }
    /**
     * Get intraDelay value
     * @return string
     */
    public function getIntraDelay()
    {
        return $this->intraDelay;
    }
    /**
     * Set intraDelay value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $intraDelay
     * @return XGatewayEndpointDigitalBri
     */
    public function setIntraDelay($intraDelay = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($intraDelay)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $intraDelay, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->intraDelay = $intraDelay;
        return $this;
    }
    /**
     * Get redirectOutboundNumberIe value
     * @return string
     */
    public function getRedirectOutboundNumberIe()
    {
        return $this->redirectOutboundNumberIe;
    }
    /**
     * Set redirectOutboundNumberIe value
     * @param string $redirectOutboundNumberIe
     * @return XGatewayEndpointDigitalBri
     */
    public function setRedirectOutboundNumberIe($redirectOutboundNumberIe = null)
    {
        // validation for constraint: pattern
        if (is_scalar($redirectOutboundNumberIe) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($redirectOutboundNumberIe, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($redirectOutboundNumberIe) && !is_string($redirectOutboundNumberIe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($redirectOutboundNumberIe)), __LINE__);
        }
        $this->redirectOutboundNumberIe = $redirectOutboundNumberIe;
        return $this;
    }
    /**
     * Get numDigitsToStrip value
     * @return string
     */
    public function getNumDigitsToStrip()
    {
        return $this->numDigitsToStrip;
    }
    /**
     * Set numDigitsToStrip value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numDigitsToStrip
     * @return XGatewayEndpointDigitalBri
     */
    public function setNumDigitsToStrip($numDigitsToStrip = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($numDigitsToStrip)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $numDigitsToStrip, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->numDigitsToStrip = $numDigitsToStrip;
        return $this;
    }
    /**
     * Get prefix value
     * @return string
     */
    public function getPrefix()
    {
        return $this->prefix;
    }
    /**
     * Set prefix value
     * @param string $prefix
     * @return XGatewayEndpointDigitalBri
     */
    public function setPrefix($prefix = null)
    {
        // validation for constraint: string
        if (!is_null($prefix) && !is_string($prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prefix)), __LINE__);
        }
        $this->prefix = $prefix;
        return $this;
    }
    /**
     * Get presentationBit value
     * @return string
     */
    public function getPresentationBit()
    {
        return $this->presentationBit;
    }
    /**
     * Set presentationBit value
     * @uses XPresentationBit::valueIsValid()
     * @uses XPresentationBit::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $presentationBit
     * @return XGatewayEndpointDigitalBri
     */
    public function setPresentationBit($presentationBit = null)
    {
        // validation for constraint: enumeration
        if (!XPresentationBit::valueIsValid($presentationBit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $presentationBit, implode(', ', XPresentationBit::getValidValues())), __LINE__);
        }
        $this->presentationBit = $presentationBit;
        return $this;
    }
    /**
     * Get sendRestart value
     * @return string
     */
    public function getSendRestart()
    {
        return $this->sendRestart;
    }
    /**
     * Set sendRestart value
     * @param string $sendRestart
     * @return XGatewayEndpointDigitalBri
     */
    public function setSendRestart($sendRestart = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sendRestart) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sendRestart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sendRestart, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sendRestart) && !is_string($sendRestart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sendRestart)), __LINE__);
        }
        $this->sendRestart = $sendRestart;
        return $this;
    }
    /**
     * Get setupNonIsdnPi value
     * @return string
     */
    public function getSetupNonIsdnPi()
    {
        return $this->setupNonIsdnPi;
    }
    /**
     * Set setupNonIsdnPi value
     * @param string $setupNonIsdnPi
     * @return XGatewayEndpointDigitalBri
     */
    public function setSetupNonIsdnPi($setupNonIsdnPi = null)
    {
        // validation for constraint: pattern
        if (is_scalar($setupNonIsdnPi) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $setupNonIsdnPi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($setupNonIsdnPi, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($setupNonIsdnPi) && !is_string($setupNonIsdnPi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($setupNonIsdnPi)), __LINE__);
        }
        $this->setupNonIsdnPi = $setupNonIsdnPi;
        return $this;
    }
    /**
     * Get sigDigits value
     * @return SigDigits
     */
    public function getSigDigits()
    {
        return $this->sigDigits;
    }
    /**
     * Set sigDigits value
     * @param SigDigits $sigDigits
     * @return XGatewayEndpointDigitalBri
     */
    public function setSigDigits(SigDigits $sigDigits = null)
    {
        $this->sigDigits = $sigDigits;
        return $this;
    }
    /**
     * Get statusPoll value
     * @return string
     */
    public function getStatusPoll()
    {
        return $this->statusPoll;
    }
    /**
     * Set statusPoll value
     * @param string $statusPoll
     * @return XGatewayEndpointDigitalBri
     */
    public function setStatusPoll($statusPoll = null)
    {
        // validation for constraint: pattern
        if (is_scalar($statusPoll) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $statusPoll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($statusPoll, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($statusPoll) && !is_string($statusPoll)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusPoll)), __LINE__);
        }
        $this->statusPoll = $statusPoll;
        return $this;
    }
    /**
     * Get GClearEnable value
     * @return string
     */
    public function getGClearEnable()
    {
        return $this->GClearEnable;
    }
    /**
     * Set GClearEnable value
     * @param string $gClearEnable
     * @return XGatewayEndpointDigitalBri
     */
    public function setGClearEnable($gClearEnable = null)
    {
        // validation for constraint: pattern
        if (is_scalar($gClearEnable) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $gClearEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($gClearEnable, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($gClearEnable) && !is_string($gClearEnable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gClearEnable)), __LINE__);
        }
        $this->GClearEnable = $gClearEnable;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return XGatewayEndpointDigitalBri
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 128) || (is_array($description) && count($description) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get networkLocation value
     * @return string|null
     */
    public function getNetworkLocation()
    {
        return $this->networkLocation;
    }
    /**
     * Set networkLocation value
     * @uses XNetworkLocation::valueIsValid()
     * @uses XNetworkLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocation
     * @return XGatewayEndpointDigitalBri
     */
    public function setNetworkLocation($networkLocation = 'Use System Default')
    {
        // validation for constraint: enumeration
        if (!XNetworkLocation::valueIsValid($networkLocation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocation, implode(', ', XNetworkLocation::getValidValues())), __LINE__);
        }
        $this->networkLocation = $networkLocation;
        return $this;
    }
    /**
     * Get networkLocale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNetworkLocale()
    {
        return isset($this->networkLocale) ? $this->networkLocale : null;
    }
    /**
     * Set networkLocale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XCountry::valueIsValid()
     * @uses XCountry::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkLocale
     * @return XGatewayEndpointDigitalBri
     */
    public function setNetworkLocale($networkLocale = null)
    {
        // validation for constraint: enumeration
        if (!XCountry::valueIsValid($networkLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkLocale, implode(', ', XCountry::getValidValues())), __LINE__);
        }
        if (is_null($networkLocale) || (is_array($networkLocale) && empty($networkLocale))) {
            unset($this->networkLocale);
        } else {
            $this->networkLocale = $networkLocale;
        }
        return $this;
    }
    /**
     * Get vendorConfig value
     * @return XVendorConfig|null
     */
    public function getVendorConfig()
    {
        return $this->vendorConfig;
    }
    /**
     * Set vendorConfig value
     * @param XVendorConfig $vendorConfig
     * @return XGatewayEndpointDigitalBri
     */
    public function setVendorConfig(XVendorConfig $vendorConfig = null)
    {
        $this->vendorConfig = $vendorConfig;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCss()
    {
        return $this->useDevicePoolCgpnTransformCss;
    }
    /**
     * Set useDevicePoolCgpnTransformCss value
     * @param string $useDevicePoolCgpnTransformCss
     * @return XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCss($useDevicePoolCgpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCss) && !is_string($useDevicePoolCgpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCss = $useDevicePoolCgpnTransformCss;
        return $this;
    }
    /**
     * Get packetCaptureMode value
     * @return string|null
     */
    public function getPacketCaptureMode()
    {
        return $this->packetCaptureMode;
    }
    /**
     * Set packetCaptureMode value
     * @uses XPacketCaptureMode::valueIsValid()
     * @uses XPacketCaptureMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureMode
     * @return XGatewayEndpointDigitalBri
     */
    public function setPacketCaptureMode($packetCaptureMode = 'None')
    {
        // validation for constraint: enumeration
        if (!XPacketCaptureMode::valueIsValid($packetCaptureMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureMode, implode(', ', XPacketCaptureMode::getValidValues())), __LINE__);
        }
        $this->packetCaptureMode = $packetCaptureMode;
        return $this;
    }
    /**
     * Get packetCaptureDuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPacketCaptureDuration()
    {
        return isset($this->packetCaptureDuration) ? $this->packetCaptureDuration : null;
    }
    /**
     * Set packetCaptureDuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $packetCaptureDuration
     * @return XGatewayEndpointDigitalBri
     */
    public function setPacketCaptureDuration($packetCaptureDuration = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($packetCaptureDuration)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $packetCaptureDuration, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($packetCaptureDuration) || (is_array($packetCaptureDuration) && empty($packetCaptureDuration))) {
            unset($this->packetCaptureDuration);
        } else {
            $this->packetCaptureDuration = $packetCaptureDuration;
        }
        return $this;
    }
    /**
     * Get cdpnTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getCdpnTransformationCssName()
    {
        return isset($this->cdpnTransformationCssName) ? $this->cdpnTransformationCssName : null;
    }
    /**
     * Set cdpnTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $cdpnTransformationCssName
     * @return XGatewayEndpointDigitalBri
     */
    public function setCdpnTransformationCssName(XFkType $cdpnTransformationCssName = null)
    {
        if (is_null($cdpnTransformationCssName) || (is_array($cdpnTransformationCssName) && empty($cdpnTransformationCssName))) {
            unset($this->cdpnTransformationCssName);
        } else {
            $this->cdpnTransformationCssName = $cdpnTransformationCssName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCdpnTransformCss value
     * @return string|null
     */
    public function getUseDevicePoolCdpnTransformCss()
    {
        return $this->useDevicePoolCdpnTransformCss;
    }
    /**
     * Set useDevicePoolCdpnTransformCss value
     * @param string $useDevicePoolCdpnTransformCss
     * @return XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCdpnTransformCss($useDevicePoolCdpnTransformCss = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCdpnTransformCss) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCdpnTransformCss, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCdpnTransformCss) && !is_string($useDevicePoolCdpnTransformCss)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCdpnTransformCss)), __LINE__);
        }
        $this->useDevicePoolCdpnTransformCss = $useDevicePoolCdpnTransformCss;
        return $this;
    }
    /**
     * Get geoLocationFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getGeoLocationFilterName()
    {
        return isset($this->geoLocationFilterName) ? $this->geoLocationFilterName : null;
    }
    /**
     * Set geoLocationFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $geoLocationFilterName
     * @return XGatewayEndpointDigitalBri
     */
    public function setGeoLocationFilterName(XFkType $geoLocationFilterName = null)
    {
        if (is_null($geoLocationFilterName) || (is_array($geoLocationFilterName) && empty($geoLocationFilterName))) {
            unset($this->geoLocationFilterName);
        } else {
            $this->geoLocationFilterName = $geoLocationFilterName;
        }
        return $this;
    }
    /**
     * Get nationalPrefix value
     * @return string|null
     */
    public function getNationalPrefix()
    {
        return $this->nationalPrefix;
    }
    /**
     * Set nationalPrefix value
     * @param string $nationalPrefix
     * @return XGatewayEndpointDigitalBri
     */
    public function setNationalPrefix($nationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($nationalPrefix) && strlen($nationalPrefix) > 16) || (is_array($nationalPrefix) && count($nationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($nationalPrefix) ? strlen($nationalPrefix) : count($nationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($nationalPrefix) && !is_string($nationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nationalPrefix)), __LINE__);
        }
        $this->nationalPrefix = $nationalPrefix;
        return $this;
    }
    /**
     * Get internationalPrefix value
     * @return string|null
     */
    public function getInternationalPrefix()
    {
        return $this->internationalPrefix;
    }
    /**
     * Set internationalPrefix value
     * @param string $internationalPrefix
     * @return XGatewayEndpointDigitalBri
     */
    public function setInternationalPrefix($internationalPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($internationalPrefix) && strlen($internationalPrefix) > 16) || (is_array($internationalPrefix) && count($internationalPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($internationalPrefix) ? strlen($internationalPrefix) : count($internationalPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($internationalPrefix) && !is_string($internationalPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internationalPrefix)), __LINE__);
        }
        $this->internationalPrefix = $internationalPrefix;
        return $this;
    }
    /**
     * Get unknownPrefix value
     * @return string|null
     */
    public function getUnknownPrefix()
    {
        return $this->unknownPrefix;
    }
    /**
     * Set unknownPrefix value
     * @param string $unknownPrefix
     * @return XGatewayEndpointDigitalBri
     */
    public function setUnknownPrefix($unknownPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($unknownPrefix) && strlen($unknownPrefix) > 16) || (is_array($unknownPrefix) && count($unknownPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($unknownPrefix) ? strlen($unknownPrefix) : count($unknownPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unknownPrefix) && !is_string($unknownPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unknownPrefix)), __LINE__);
        }
        $this->unknownPrefix = $unknownPrefix;
        return $this;
    }
    /**
     * Get subscriberPrefix value
     * @return string|null
     */
    public function getSubscriberPrefix()
    {
        return $this->subscriberPrefix;
    }
    /**
     * Set subscriberPrefix value
     * @param string $subscriberPrefix
     * @return XGatewayEndpointDigitalBri
     */
    public function setSubscriberPrefix($subscriberPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subscriberPrefix) && strlen($subscriberPrefix) > 16) || (is_array($subscriberPrefix) && count($subscriberPrefix) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($subscriberPrefix) ? strlen($subscriberPrefix) : count($subscriberPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subscriberPrefix) && !is_string($subscriberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subscriberPrefix)), __LINE__);
        }
        $this->subscriberPrefix = $subscriberPrefix;
        return $this;
    }
    /**
     * Get nationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationalStripDigits()
    {
        return isset($this->nationalStripDigits) ? $this->nationalStripDigits : null;
    }
    /**
     * Set nationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nationalStripDigits
     * @return XGatewayEndpointDigitalBri
     */
    public function setNationalStripDigits($nationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($nationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nationalStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($nationalStripDigits) || (is_array($nationalStripDigits) && empty($nationalStripDigits))) {
            unset($this->nationalStripDigits);
        } else {
            $this->nationalStripDigits = $nationalStripDigits;
        }
        return $this;
    }
    /**
     * Get internationalStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInternationalStripDigits()
    {
        return isset($this->internationalStripDigits) ? $this->internationalStripDigits : null;
    }
    /**
     * Set internationalStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $internationalStripDigits
     * @return XGatewayEndpointDigitalBri
     */
    public function setInternationalStripDigits($internationalStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($internationalStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $internationalStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($internationalStripDigits) || (is_array($internationalStripDigits) && empty($internationalStripDigits))) {
            unset($this->internationalStripDigits);
        } else {
            $this->internationalStripDigits = $internationalStripDigits;
        }
        return $this;
    }
    /**
     * Get unknownStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnknownStripDigits()
    {
        return isset($this->unknownStripDigits) ? $this->unknownStripDigits : null;
    }
    /**
     * Set unknownStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $unknownStripDigits
     * @return XGatewayEndpointDigitalBri
     */
    public function setUnknownStripDigits($unknownStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($unknownStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $unknownStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($unknownStripDigits) || (is_array($unknownStripDigits) && empty($unknownStripDigits))) {
            unset($this->unknownStripDigits);
        } else {
            $this->unknownStripDigits = $unknownStripDigits;
        }
        return $this;
    }
    /**
     * Get subscriberStripDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberStripDigits()
    {
        return isset($this->subscriberStripDigits) ? $this->subscriberStripDigits : null;
    }
    /**
     * Set subscriberStripDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberStripDigits
     * @return XGatewayEndpointDigitalBri
     */
    public function setSubscriberStripDigits($subscriberStripDigits = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($subscriberStripDigits)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subscriberStripDigits, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        if (is_null($subscriberStripDigits) || (is_array($subscriberStripDigits) && empty($subscriberStripDigits))) {
            unset($this->subscriberStripDigits);
        } else {
            $this->subscriberStripDigits = $subscriberStripDigits;
        }
        return $this;
    }
    /**
     * Get nationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNationalTransformationCssName()
    {
        return isset($this->nationalTransformationCssName) ? $this->nationalTransformationCssName : null;
    }
    /**
     * Set nationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $nationalTransformationCssName
     * @return XGatewayEndpointDigitalBri
     */
    public function setNationalTransformationCssName(XFkType $nationalTransformationCssName = null)
    {
        if (is_null($nationalTransformationCssName) || (is_array($nationalTransformationCssName) && empty($nationalTransformationCssName))) {
            unset($this->nationalTransformationCssName);
        } else {
            $this->nationalTransformationCssName = $nationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get internationalTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getInternationalTransformationCssName()
    {
        return isset($this->internationalTransformationCssName) ? $this->internationalTransformationCssName : null;
    }
    /**
     * Set internationalTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $internationalTransformationCssName
     * @return XGatewayEndpointDigitalBri
     */
    public function setInternationalTransformationCssName(XFkType $internationalTransformationCssName = null)
    {
        if (is_null($internationalTransformationCssName) || (is_array($internationalTransformationCssName) && empty($internationalTransformationCssName))) {
            unset($this->internationalTransformationCssName);
        } else {
            $this->internationalTransformationCssName = $internationalTransformationCssName;
        }
        return $this;
    }
    /**
     * Get unknownTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getUnknownTransformationCssName()
    {
        return isset($this->unknownTransformationCssName) ? $this->unknownTransformationCssName : null;
    }
    /**
     * Set unknownTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $unknownTransformationCssName
     * @return XGatewayEndpointDigitalBri
     */
    public function setUnknownTransformationCssName(XFkType $unknownTransformationCssName = null)
    {
        if (is_null($unknownTransformationCssName) || (is_array($unknownTransformationCssName) && empty($unknownTransformationCssName))) {
            unset($this->unknownTransformationCssName);
        } else {
            $this->unknownTransformationCssName = $unknownTransformationCssName;
        }
        return $this;
    }
    /**
     * Get subscriberTransformationCssName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getSubscriberTransformationCssName()
    {
        return isset($this->subscriberTransformationCssName) ? $this->subscriberTransformationCssName : null;
    }
    /**
     * Set subscriberTransformationCssName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $subscriberTransformationCssName
     * @return XGatewayEndpointDigitalBri
     */
    public function setSubscriberTransformationCssName(XFkType $subscriberTransformationCssName = null)
    {
        if (is_null($subscriberTransformationCssName) || (is_array($subscriberTransformationCssName) && empty($subscriberTransformationCssName))) {
            unset($this->subscriberTransformationCssName);
        } else {
            $this->subscriberTransformationCssName = $subscriberTransformationCssName;
        }
        return $this;
    }
    /**
     * Get pstnAccess value
     * @return string|null
     */
    public function getPstnAccess()
    {
        return $this->pstnAccess;
    }
    /**
     * Set pstnAccess value
     * @param string $pstnAccess
     * @return XGatewayEndpointDigitalBri
     */
    public function setPstnAccess($pstnAccess = true)
    {
        // validation for constraint: pattern
        if (is_scalar($pstnAccess) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($pstnAccess, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnAccess) && !is_string($pstnAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnAccess)), __LINE__);
        }
        $this->pstnAccess = $pstnAccess;
        return $this;
    }
    /**
     * Get imeE164TransformationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getImeE164TransformationName()
    {
        return isset($this->imeE164TransformationName) ? $this->imeE164TransformationName : null;
    }
    /**
     * Set imeE164TransformationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $imeE164TransformationName
     * @return XGatewayEndpointDigitalBri
     */
    public function setImeE164TransformationName(XFkType $imeE164TransformationName = null)
    {
        if (is_null($imeE164TransformationName) || (is_array($imeE164TransformationName) && empty($imeE164TransformationName))) {
            unset($this->imeE164TransformationName);
        } else {
            $this->imeE164TransformationName = $imeE164TransformationName;
        }
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssNatl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssNatl()
    {
        return $this->useDevicePoolCgpnTransformCssNatl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssNatl value
     * @param string $useDevicePoolCgpnTransformCssNatl
     * @return XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssNatl($useDevicePoolCgpnTransformCssNatl = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssNatl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssNatl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssNatl) && !is_string($useDevicePoolCgpnTransformCssNatl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssNatl)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssNatl = $useDevicePoolCgpnTransformCssNatl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssIntl value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssIntl()
    {
        return $this->useDevicePoolCgpnTransformCssIntl;
    }
    /**
     * Set useDevicePoolCgpnTransformCssIntl value
     * @param string $useDevicePoolCgpnTransformCssIntl
     * @return XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssIntl($useDevicePoolCgpnTransformCssIntl = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssIntl) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssIntl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssIntl) && !is_string($useDevicePoolCgpnTransformCssIntl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssIntl)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssIntl = $useDevicePoolCgpnTransformCssIntl;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssUnkn value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssUnkn()
    {
        return $this->useDevicePoolCgpnTransformCssUnkn;
    }
    /**
     * Set useDevicePoolCgpnTransformCssUnkn value
     * @param string $useDevicePoolCgpnTransformCssUnkn
     * @return XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssUnkn($useDevicePoolCgpnTransformCssUnkn = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssUnkn) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssUnkn, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssUnkn) && !is_string($useDevicePoolCgpnTransformCssUnkn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssUnkn)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssUnkn = $useDevicePoolCgpnTransformCssUnkn;
        return $this;
    }
    /**
     * Get useDevicePoolCgpnTransformCssSubs value
     * @return string|null
     */
    public function getUseDevicePoolCgpnTransformCssSubs()
    {
        return $this->useDevicePoolCgpnTransformCssSubs;
    }
    /**
     * Set useDevicePoolCgpnTransformCssSubs value
     * @param string $useDevicePoolCgpnTransformCssSubs
     * @return XGatewayEndpointDigitalBri
     */
    public function setUseDevicePoolCgpnTransformCssSubs($useDevicePoolCgpnTransformCssSubs = true)
    {
        // validation for constraint: pattern
        if (is_scalar($useDevicePoolCgpnTransformCssSubs) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useDevicePoolCgpnTransformCssSubs, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useDevicePoolCgpnTransformCssSubs) && !is_string($useDevicePoolCgpnTransformCssSubs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useDevicePoolCgpnTransformCssSubs)), __LINE__);
        }
        $this->useDevicePoolCgpnTransformCssSubs = $useDevicePoolCgpnTransformCssSubs;
        return $this;
    }
    /**
     * Get ctiid value
     * @return int|null
     */
    public function getCtiid()
    {
        return $this->ctiid;
    }
    /**
     * Set ctiid value
     * @param int $ctiid
     * @return XGatewayEndpointDigitalBri
     */
    public function setCtiid($ctiid = null)
    {
        // validation for constraint: int
        if (!is_null($ctiid) && !is_numeric($ctiid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ctiid)), __LINE__);
        }
        $this->ctiid = $ctiid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XGatewayEndpointDigitalBri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
