<?php
/**
 * This class stands for XDeviceTrustMode EnumType
 * @subpackage Enumerations
 */
class XDeviceTrustMode
{
    /**
     * Constant for value 'Not Trusted'
     * @return string 'Not Trusted'
     */
    const VALUE_NOT_TRUSTED = 'Not Trusted';
    /**
     * Constant for value 'Trusted'
     * @return string 'Trusted'
     */
    const VALUE_TRUSTED = 'Trusted';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_TRUSTED
     * @uses self::VALUE_TRUSTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_TRUSTED,
            self::VALUE_TRUSTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
