<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XDateTimeGroupNtpReference StructType
 * @subpackage Structs
 */
class XDateTimeGroupNtpReference extends AbstractStructBase
{
    /**
     * The phoneNtpName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var XFkType
     */
    public $phoneNtpName;
    /**
     * The selectionOrder
     * Meta informations extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $selectionOrder;
    /**
     * Constructor method for XDateTimeGroupNtpReference
     * @uses XDateTimeGroupNtpReference::setPhoneNtpName()
     * @uses XDateTimeGroupNtpReference::setSelectionOrder()
     * @param XFkType $phoneNtpName
     * @param string $selectionOrder
     */
    public function __construct(XFkType $phoneNtpName = null, $selectionOrder = '0')
    {
        $this
            ->setPhoneNtpName($phoneNtpName)
            ->setSelectionOrder($selectionOrder);
    }
    /**
     * Get phoneNtpName value
     * @return XFkType
     */
    public function getPhoneNtpName()
    {
        return $this->phoneNtpName;
    }
    /**
     * Set phoneNtpName value
     * @param XFkType $phoneNtpName
     * @return XDateTimeGroupNtpReference
     */
    public function setPhoneNtpName(XFkType $phoneNtpName = null)
    {
        $this->phoneNtpName = $phoneNtpName;
        return $this;
    }
    /**
     * Get selectionOrder value
     * @return string
     */
    public function getSelectionOrder()
    {
        return $this->selectionOrder;
    }
    /**
     * Set selectionOrder value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $selectionOrder
     * @return XDateTimeGroupNtpReference
     */
    public function setSelectionOrder($selectionOrder = '0')
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($selectionOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $selectionOrder, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->selectionOrder = $selectionOrder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XDateTimeGroupNtpReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
