<?php
/**
 * This class stands for XDPJobStatus EnumType
 * @subpackage Enumerations
 */
class XDPJobStatus
{
    /**
     * Constant for value 'Scheduled'
     * @return string 'Scheduled'
     */
    const VALUE_SCHEDULED = 'Scheduled';
    /**
     * Constant for value 'Running'
     * @return string 'Running'
     */
    const VALUE_RUNNING = 'Running';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'Pending'
     * @return string 'Pending'
     */
    const VALUE_PENDING = 'Pending';
    /**
     * Constant for value 'Aborted'
     * @return string 'Aborted'
     */
    const VALUE_ABORTED = 'Aborted';
    /**
     * Constant for value 'Canceled'
     * @return string 'Canceled'
     */
    const VALUE_CANCELED = 'Canceled';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SCHEDULED
     * @uses self::VALUE_RUNNING
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_PENDING
     * @uses self::VALUE_ABORTED
     * @uses self::VALUE_CANCELED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SCHEDULED,
            self::VALUE_RUNNING,
            self::VALUE_COMPLETED,
            self::VALUE_PENDING,
            self::VALUE_ABORTED,
            self::VALUE_CANCELED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
