<?php
/**
 * This class stands for XCustomUserAttribute EnumType
 * @subpackage Enumerations
 */
class XCustomUserAttribute
{
    /**
     * Constant for value 'CustomField1'
     * @return string 'CustomField1'
     */
    const VALUE_CUSTOM_FIELD_1 = 'CustomField1';
    /**
     * Constant for value 'CustomField2'
     * @return string 'CustomField2'
     */
    const VALUE_CUSTOM_FIELD_2 = 'CustomField2';
    /**
     * Constant for value 'CustomField3'
     * @return string 'CustomField3'
     */
    const VALUE_CUSTOM_FIELD_3 = 'CustomField3';
    /**
     * Constant for value 'CustomField4'
     * @return string 'CustomField4'
     */
    const VALUE_CUSTOM_FIELD_4 = 'CustomField4';
    /**
     * Constant for value 'CustomField5'
     * @return string 'CustomField5'
     */
    const VALUE_CUSTOM_FIELD_5 = 'CustomField5';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CUSTOM_FIELD_1
     * @uses self::VALUE_CUSTOM_FIELD_2
     * @uses self::VALUE_CUSTOM_FIELD_3
     * @uses self::VALUE_CUSTOM_FIELD_4
     * @uses self::VALUE_CUSTOM_FIELD_5
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CUSTOM_FIELD_1,
            self::VALUE_CUSTOM_FIELD_2,
            self::VALUE_CUSTOM_FIELD_3,
            self::VALUE_CUSTOM_FIELD_4,
            self::VALUE_CUSTOM_FIELD_5,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
