<?php
/**
 * This class stands for XContact EnumType
 * @subpackage Enumerations
 */
class XContact
{
    /**
     * Constant for value ''Corporate / Federated Domain User''
     * @return string ''Corporate / Federated Domain User''
     */
    const VALUE_CORPORATE_FEDERATED_DOMAIN_USER = '\'Corporate / Federated Domain User\'';
    /**
     * Constant for value ''Private Manually Entered Contact''
     * @return string ''Private Manually Entered Contact''
     */
    const VALUE_PRIVATE_MANUALLY_ENTERED_CONTACT = '\'Private Manually Entered Contact\'';
    /**
     * Constant for value ''Enterprise User Group As Contact / Buddy Reference''
     * @return string ''Enterprise User Group As Contact / Buddy Reference''
     */
    const VALUE_ENTERPRISE_USER_GROUP_AS_CONTACT_BUDDY_REFERENCE = '\'Enterprise User Group As Contact / Buddy Reference\'';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CORPORATE_FEDERATED_DOMAIN_USER
     * @uses self::VALUE_PRIVATE_MANUALLY_ENTERED_CONTACT
     * @uses self::VALUE_ENTERPRISE_USER_GROUP_AS_CONTACT_BUDDY_REFERENCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CORPORATE_FEDERATED_DOMAIN_USER,
            self::VALUE_PRIVATE_MANUALLY_ENTERED_CONTACT,
            self::VALUE_ENTERPRISE_USER_GROUP_AS_CONTACT_BUDDY_REFERENCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
