<?php
/**
 * This class stands for XCodec EnumType
 * @subpackage Enumerations
 */
class XCodec
{
    /**
     * Constant for value 'G.711 A-Law 64k'
     * @return string 'G.711 A-Law 64k'
     */
    const VALUE_G_711_A_LAW_64_K = 'G.711 A-Law 64k';
    /**
     * Constant for value 'G.711 A-Law 56k'
     * @return string 'G.711 A-Law 56k'
     */
    const VALUE_G_711_A_LAW_56_K = 'G.711 A-Law 56k';
    /**
     * Constant for value 'G.711 U-Law 64k'
     * @return string 'G.711 U-Law 64k'
     */
    const VALUE_G_711_U_LAW_64_K = 'G.711 U-Law 64k';
    /**
     * Constant for value 'G.711 U-Law 56k'
     * @return string 'G.711 U-Law 56k'
     */
    const VALUE_G_711_U_LAW_56_K = 'G.711 U-Law 56k';
    /**
     * Constant for value 'G.722 64k'
     * @return string 'G.722 64k'
     */
    const VALUE_G_722_64_K = 'G.722 64k';
    /**
     * Constant for value 'G.722 56k'
     * @return string 'G.722 56k'
     */
    const VALUE_G_722_56_K = 'G.722 56k';
    /**
     * Constant for value 'G.722 48k'
     * @return string 'G.722 48k'
     */
    const VALUE_G_722_48_K = 'G.722 48k';
    /**
     * Constant for value 'G.723.1 7k'
     * @return string 'G.723.1 7k'
     */
    const VALUE_G_723_1_7_K = 'G.723.1 7k';
    /**
     * Constant for value 'G.728 16k'
     * @return string 'G.728 16k'
     */
    const VALUE_G_728_16_K = 'G.728 16k';
    /**
     * Constant for value 'G.729 8k'
     * @return string 'G.729 8k'
     */
    const VALUE_G_729_8_K = 'G.729 8k';
    /**
     * Constant for value 'G.729a 8k'
     * @return string 'G.729a 8k'
     */
    const VALUE_G_729_A_8_K = 'G.729a 8k';
    /**
     * Constant for value 'G.729b 8k'
     * @return string 'G.729b 8k'
     */
    const VALUE_G_729_B_8_K = 'G.729b 8k';
    /**
     * Constant for value 'G.729ab 8k'
     * @return string 'G.729ab 8k'
     */
    const VALUE_G_729_AB_8_K = 'G.729ab 8k';
    /**
     * Constant for value 'GSM Full Rate 13k'
     * @return string 'GSM Full Rate 13k'
     */
    const VALUE_GSM_FULL_RATE_13_K = 'GSM Full Rate 13k';
    /**
     * Constant for value 'GSM Half Rate 6k'
     * @return string 'GSM Half Rate 6k'
     */
    const VALUE_GSM_HALF_RATE_6_K = 'GSM Half Rate 6k';
    /**
     * Constant for value 'GSM Enhanced Full Rate 13k'
     * @return string 'GSM Enhanced Full Rate 13k'
     */
    const VALUE_GSM_ENHANCED_FULL_RATE_13_K = 'GSM Enhanced Full Rate 13k';
    /**
     * Constant for value 'L16 256k'
     * @return string 'L16 256k'
     */
    const VALUE_L_16_256_K = 'L16 256k';
    /**
     * Constant for value 'G.722.1 32k'
     * @return string 'G.722.1 32k'
     */
    const VALUE_G_722_1_32_K = 'G.722.1 32k';
    /**
     * Constant for value 'G.722.1 24k'
     * @return string 'G.722.1 24k'
     */
    const VALUE_G_722_1_24_K = 'G.722.1 24k';
    /**
     * Constant for value 'AAC-LD (MP4A Generic)'
     * @return string 'AAC-LD (MP4A Generic)'
     */
    const VALUE_AAC_LD_MP_4_A_GENERIC = 'AAC-LD (MP4A Generic)';
    /**
     * Constant for value 'MP4A-LATM 128k'
     * @return string 'MP4A-LATM 128k'
     */
    const VALUE_MP_4_A_LATM_128_K = 'MP4A-LATM 128k';
    /**
     * Constant for value 'MP4A-LATM 64k'
     * @return string 'MP4A-LATM 64k'
     */
    const VALUE_MP_4_A_LATM_64_K = 'MP4A-LATM 64k';
    /**
     * Constant for value 'MP4A-LATM 56k'
     * @return string 'MP4A-LATM 56k'
     */
    const VALUE_MP_4_A_LATM_56_K = 'MP4A-LATM 56k';
    /**
     * Constant for value 'MP4A-LATM 48k'
     * @return string 'MP4A-LATM 48k'
     */
    const VALUE_MP_4_A_LATM_48_K = 'MP4A-LATM 48k';
    /**
     * Constant for value 'MP4A-LATM 32k'
     * @return string 'MP4A-LATM 32k'
     */
    const VALUE_MP_4_A_LATM_32_K = 'MP4A-LATM 32k';
    /**
     * Constant for value 'MP4A-LATM 24k'
     * @return string 'MP4A-LATM 24k'
     */
    const VALUE_MP_4_A_LATM_24_K = 'MP4A-LATM 24k';
    /**
     * Constant for value 'ILBC 16k'
     * @return string 'ILBC 16k'
     */
    const VALUE_ILBC_16_K = 'ILBC 16k';
    /**
     * Constant for value 'ISAC 32k'
     * @return string 'ISAC 32k'
     */
    const VALUE_ISAC_32_K = 'ISAC 32k';
    /**
     * Constant for value 'AMR (5k-13k)'
     * @return string 'AMR (5k-13k)'
     */
    const VALUE_AMR_5_K_13_K = 'AMR (5k-13k)';
    /**
     * Constant for value 'AMR-WB (7k-24k)'
     * @return string 'AMR-WB (7k-24k)'
     */
    const VALUE_AMR_WB_7_K_24_K = 'AMR-WB (7k-24k)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_G_711_A_LAW_64_K
     * @uses self::VALUE_G_711_A_LAW_56_K
     * @uses self::VALUE_G_711_U_LAW_64_K
     * @uses self::VALUE_G_711_U_LAW_56_K
     * @uses self::VALUE_G_722_64_K
     * @uses self::VALUE_G_722_56_K
     * @uses self::VALUE_G_722_48_K
     * @uses self::VALUE_G_723_1_7_K
     * @uses self::VALUE_G_728_16_K
     * @uses self::VALUE_G_729_8_K
     * @uses self::VALUE_G_729_A_8_K
     * @uses self::VALUE_G_729_B_8_K
     * @uses self::VALUE_G_729_AB_8_K
     * @uses self::VALUE_GSM_FULL_RATE_13_K
     * @uses self::VALUE_GSM_HALF_RATE_6_K
     * @uses self::VALUE_GSM_ENHANCED_FULL_RATE_13_K
     * @uses self::VALUE_L_16_256_K
     * @uses self::VALUE_G_722_1_32_K
     * @uses self::VALUE_G_722_1_24_K
     * @uses self::VALUE_AAC_LD_MP_4_A_GENERIC
     * @uses self::VALUE_MP_4_A_LATM_128_K
     * @uses self::VALUE_MP_4_A_LATM_64_K
     * @uses self::VALUE_MP_4_A_LATM_56_K
     * @uses self::VALUE_MP_4_A_LATM_48_K
     * @uses self::VALUE_MP_4_A_LATM_32_K
     * @uses self::VALUE_MP_4_A_LATM_24_K
     * @uses self::VALUE_ILBC_16_K
     * @uses self::VALUE_ISAC_32_K
     * @uses self::VALUE_AMR_5_K_13_K
     * @uses self::VALUE_AMR_WB_7_K_24_K
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_G_711_A_LAW_64_K,
            self::VALUE_G_711_A_LAW_56_K,
            self::VALUE_G_711_U_LAW_64_K,
            self::VALUE_G_711_U_LAW_56_K,
            self::VALUE_G_722_64_K,
            self::VALUE_G_722_56_K,
            self::VALUE_G_722_48_K,
            self::VALUE_G_723_1_7_K,
            self::VALUE_G_728_16_K,
            self::VALUE_G_729_8_K,
            self::VALUE_G_729_A_8_K,
            self::VALUE_G_729_B_8_K,
            self::VALUE_G_729_AB_8_K,
            self::VALUE_GSM_FULL_RATE_13_K,
            self::VALUE_GSM_HALF_RATE_6_K,
            self::VALUE_GSM_ENHANCED_FULL_RATE_13_K,
            self::VALUE_L_16_256_K,
            self::VALUE_G_722_1_32_K,
            self::VALUE_G_722_1_24_K,
            self::VALUE_AAC_LD_MP_4_A_GENERIC,
            self::VALUE_MP_4_A_LATM_128_K,
            self::VALUE_MP_4_A_LATM_64_K,
            self::VALUE_MP_4_A_LATM_56_K,
            self::VALUE_MP_4_A_LATM_48_K,
            self::VALUE_MP_4_A_LATM_32_K,
            self::VALUE_MP_4_A_LATM_24_K,
            self::VALUE_ILBC_16_K,
            self::VALUE_ISAC_32_K,
            self::VALUE_AMR_5_K_13_K,
            self::VALUE_AMR_WB_7_K_24_K,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
