<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XCcmExternalIpMap StructType
 * @subpackage Structs
 */
class XCcmExternalIpMap extends AbstractStructBase
{
    /**
     * The callManagerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $callManagerName;
    /**
     * The ipAddressHost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $ipAddressHost;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - default: 5060
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $port;
    /**
     * Constructor method for XCcmExternalIpMap
     * @uses XCcmExternalIpMap::setCallManagerName()
     * @uses XCcmExternalIpMap::setIpAddressHost()
     * @uses XCcmExternalIpMap::setPort()
     * @param XFkType $callManagerName
     * @param string $ipAddressHost
     * @param string $port
     */
    public function __construct(XFkType $callManagerName = null, $ipAddressHost = null, $port = '5060')
    {
        $this
            ->setCallManagerName($callManagerName)
            ->setIpAddressHost($ipAddressHost)
            ->setPort($port);
    }
    /**
     * Get callManagerName value
     * @return XFkType|null
     */
    public function getCallManagerName()
    {
        return $this->callManagerName;
    }
    /**
     * Set callManagerName value
     * @param XFkType $callManagerName
     * @return XCcmExternalIpMap
     */
    public function setCallManagerName(XFkType $callManagerName = null)
    {
        $this->callManagerName = $callManagerName;
        return $this;
    }
    /**
     * Get ipAddressHost value
     * @return string|null
     */
    public function getIpAddressHost()
    {
        return $this->ipAddressHost;
    }
    /**
     * Set ipAddressHost value
     * @param string $ipAddressHost
     * @return XCcmExternalIpMap
     */
    public function setIpAddressHost($ipAddressHost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipAddressHost) && strlen($ipAddressHost) > 255) || (is_array($ipAddressHost) && count($ipAddressHost) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($ipAddressHost) ? strlen($ipAddressHost) : count($ipAddressHost)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipAddressHost) && !is_string($ipAddressHost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipAddressHost)), __LINE__);
        }
        $this->ipAddressHost = $ipAddressHost;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return XCcmExternalIpMap
     */
    public function setPort($port = '5060')
    {
        // validation for constraint: maxLength
        if ((is_scalar($port) && strlen($port) > 255) || (is_array($port) && count($port) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($port) ? strlen($port) : count($port)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($port) && !is_string($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($port)), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XCcmExternalIpMap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
