<?php
/**
 * This class stands for XCarrierSelectCode EnumType
 * @subpackage Enumerations
 */
class XCarrierSelectCode
{
    /**
     * Constant for value 'Long Distance Fixed'
     * @return string 'Long Distance Fixed'
     */
    const VALUE_LONG_DISTANCE_FIXED = 'Long Distance Fixed';
    /**
     * Constant for value 'Long Distance Mobile'
     * @return string 'Long Distance Mobile'
     */
    const VALUE_LONG_DISTANCE_MOBILE = 'Long Distance Mobile';
    /**
     * Constant for value 'International'
     * @return string 'International'
     */
    const VALUE_INTERNATIONAL = 'International';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LONG_DISTANCE_FIXED
     * @uses self::VALUE_LONG_DISTANCE_MOBILE
     * @uses self::VALUE_INTERNATIONAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LONG_DISTANCE_FIXED,
            self::VALUE_LONG_DISTANCE_MOBILE,
            self::VALUE_INTERNATIONAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
