<?php
/**
 * This class stands for XCallingPartySelection EnumType
 * @subpackage Enumerations
 */
class XCallingPartySelection
{
    /**
     * Constant for value 'Originator'
     * @return string 'Originator'
     */
    const VALUE_ORIGINATOR = 'Originator';
    /**
     * Constant for value 'First Redirect Number'
     * @return string 'First Redirect Number'
     */
    const VALUE_FIRST_REDIRECT_NUMBER = 'First Redirect Number';
    /**
     * Constant for value 'Last Redirect Number'
     * @return string 'Last Redirect Number'
     */
    const VALUE_LAST_REDIRECT_NUMBER = 'Last Redirect Number';
    /**
     * Constant for value 'First Redirect Number (External)'
     * @return string 'First Redirect Number (External)'
     */
    const VALUE_FIRST_REDIRECT_NUMBER_EXTERNAL = 'First Redirect Number (External)';
    /**
     * Constant for value 'Last Redirect Number (External)'
     * @return string 'Last Redirect Number (External)'
     */
    const VALUE_LAST_REDIRECT_NUMBER_EXTERNAL = 'Last Redirect Number (External)';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ORIGINATOR
     * @uses self::VALUE_FIRST_REDIRECT_NUMBER
     * @uses self::VALUE_LAST_REDIRECT_NUMBER
     * @uses self::VALUE_FIRST_REDIRECT_NUMBER_EXTERNAL
     * @uses self::VALUE_LAST_REDIRECT_NUMBER_EXTERNAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ORIGINATOR,
            self::VALUE_FIRST_REDIRECT_NUMBER,
            self::VALUE_LAST_REDIRECT_NUMBER,
            self::VALUE_FIRST_REDIRECT_NUMBER_EXTERNAL,
            self::VALUE_LAST_REDIRECT_NUMBER_EXTERNAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
