<?php
/**
 * This class stands for XCallState EnumType
 * @subpackage Enumerations
 */
class XCallState
{
    /**
     * Constant for value 'On Hook'
     * @return string 'On Hook'
     */
    const VALUE_ON_HOOK = 'On Hook';
    /**
     * Constant for value 'Connected'
     * @return string 'Connected'
     */
    const VALUE_CONNECTED = 'Connected';
    /**
     * Constant for value 'On Hold'
     * @return string 'On Hold'
     */
    const VALUE_ON_HOLD = 'On Hold';
    /**
     * Constant for value 'Ring In'
     * @return string 'Ring In'
     */
    const VALUE_RING_IN = 'Ring In';
    /**
     * Constant for value 'Off Hook'
     * @return string 'Off Hook'
     */
    const VALUE_OFF_HOOK = 'Off Hook';
    /**
     * Constant for value 'Connected Transfer'
     * @return string 'Connected Transfer'
     */
    const VALUE_CONNECTED_TRANSFER = 'Connected Transfer';
    /**
     * Constant for value 'Digits After First'
     * @return string 'Digits After First'
     */
    const VALUE_DIGITS_AFTER_FIRST = 'Digits After First';
    /**
     * Constant for value 'Connected Conference'
     * @return string 'Connected Conference'
     */
    const VALUE_CONNECTED_CONFERENCE = 'Connected Conference';
    /**
     * Constant for value 'Ring Out'
     * @return string 'Ring Out'
     */
    const VALUE_RING_OUT = 'Ring Out';
    /**
     * Constant for value 'Off Hook With Feature'
     * @return string 'Off Hook With Feature'
     */
    const VALUE_OFF_HOOK_WITH_FEATURE = 'Off Hook With Feature';
    /**
     * Constant for value 'Remote In Use'
     * @return string 'Remote In Use'
     */
    const VALUE_REMOTE_IN_USE = 'Remote In Use';
    /**
     * Constant for value 'Connected No Feature'
     * @return string 'Connected No Feature'
     */
    const VALUE_CONNECTED_NO_FEATURE = 'Connected No Feature';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ON_HOOK
     * @uses self::VALUE_CONNECTED
     * @uses self::VALUE_ON_HOLD
     * @uses self::VALUE_RING_IN
     * @uses self::VALUE_OFF_HOOK
     * @uses self::VALUE_CONNECTED_TRANSFER
     * @uses self::VALUE_DIGITS_AFTER_FIRST
     * @uses self::VALUE_CONNECTED_CONFERENCE
     * @uses self::VALUE_RING_OUT
     * @uses self::VALUE_OFF_HOOK_WITH_FEATURE
     * @uses self::VALUE_REMOTE_IN_USE
     * @uses self::VALUE_CONNECTED_NO_FEATURE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ON_HOOK,
            self::VALUE_CONNECTED,
            self::VALUE_ON_HOLD,
            self::VALUE_RING_IN,
            self::VALUE_OFF_HOOK,
            self::VALUE_CONNECTED_TRANSFER,
            self::VALUE_DIGITS_AFTER_FIRST,
            self::VALUE_CONNECTED_CONFERENCE,
            self::VALUE_RING_OUT,
            self::VALUE_OFF_HOOK_WITH_FEATURE,
            self::VALUE_REMOTE_IN_USE,
            self::VALUE_CONNECTED_NO_FEATURE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
