<?php
/**
 * This class stands for XBATFrequency EnumType
 * @subpackage Enumerations
 */
class XBATFrequency
{
    /**
     * Constant for value 'Once'
     * @return string 'Once'
     */
    const VALUE_ONCE = 'Once';
    /**
     * Constant for value 'Monthly'
     * @return string 'Monthly'
     */
    const VALUE_MONTHLY = 'Monthly';
    /**
     * Constant for value 'Weekly'
     * @return string 'Weekly'
     */
    const VALUE_WEEKLY = 'Weekly';
    /**
     * Constant for value 'Daily'
     * @return string 'Daily'
     */
    const VALUE_DAILY = 'Daily';
    /**
     * Constant for value 'Hourly'
     * @return string 'Hourly'
     */
    const VALUE_HOURLY = 'Hourly';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ONCE
     * @uses self::VALUE_MONTHLY
     * @uses self::VALUE_WEEKLY
     * @uses self::VALUE_DAILY
     * @uses self::VALUE_HOURLY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ONCE,
            self::VALUE_MONTHLY,
            self::VALUE_WEEKLY,
            self::VALUE_DAILY,
            self::VALUE_HOURLY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
