<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for XApplicationUserCapfProfile StructType
 * @subpackage Structs
 */
class XApplicationUserCapfProfile extends AbstractStructBase
{
    /**
     * The applicationUser
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $applicationUser;
    /**
     * The instanceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $instanceId;
    /**
     * The certificateOperation
     * Meta informations extracted from the WSDL
     * - default: No Pending Operation
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $certificateOperation;
    /**
     * The authenticationMode
     * Meta informations extracted from the WSDL
     * - default: By Null String
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $authenticationMode;
    /**
     * The keySize
     * Meta informations extracted from the WSDL
     * - default: 1024
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $keySize;
    /**
     * The authenticationString
     * Meta informations extracted from the WSDL
     * - documentation: Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $authenticationString;
    /**
     * The operationCompletion
     * Meta informations extracted from the WSDL
     * - documentation: Format is YYYY:MM:DD:HH. Read Only when certificateOperation is 'No Pending Operation'
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $operationCompletion;
    /**
     * Constructor method for XApplicationUserCapfProfile
     * @uses XApplicationUserCapfProfile::setApplicationUser()
     * @uses XApplicationUserCapfProfile::setInstanceId()
     * @uses XApplicationUserCapfProfile::setCertificateOperation()
     * @uses XApplicationUserCapfProfile::setAuthenticationMode()
     * @uses XApplicationUserCapfProfile::setKeySize()
     * @uses XApplicationUserCapfProfile::setAuthenticationString()
     * @uses XApplicationUserCapfProfile::setOperationCompletion()
     * @param XFkType $applicationUser
     * @param string $instanceId
     * @param string $certificateOperation
     * @param string $authenticationMode
     * @param string $keySize
     * @param string $authenticationString
     * @param string $operationCompletion
     */
    public function __construct(XFkType $applicationUser = null, $instanceId = null, $certificateOperation = 'No Pending Operation', $authenticationMode = 'By Null String', $keySize = '1024', $authenticationString = null, $operationCompletion = null)
    {
        $this
            ->setApplicationUser($applicationUser)
            ->setInstanceId($instanceId)
            ->setCertificateOperation($certificateOperation)
            ->setAuthenticationMode($authenticationMode)
            ->setKeySize($keySize)
            ->setAuthenticationString($authenticationString)
            ->setOperationCompletion($operationCompletion);
    }
    /**
     * Get applicationUser value
     * @return XFkType
     */
    public function getApplicationUser()
    {
        return $this->applicationUser;
    }
    /**
     * Set applicationUser value
     * @param XFkType $applicationUser
     * @return XApplicationUserCapfProfile
     */
    public function setApplicationUser(XFkType $applicationUser = null)
    {
        $this->applicationUser = $applicationUser;
        return $this;
    }
    /**
     * Get instanceId value
     * @return string
     */
    public function getInstanceId()
    {
        return $this->instanceId;
    }
    /**
     * Set instanceId value
     * @param string $instanceId
     * @return XApplicationUserCapfProfile
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instanceId)), __LINE__);
        }
        $this->instanceId = $instanceId;
        return $this;
    }
    /**
     * Get certificateOperation value
     * @return string
     */
    public function getCertificateOperation()
    {
        return $this->certificateOperation;
    }
    /**
     * Set certificateOperation value
     * @uses XCertificateOperation::valueIsValid()
     * @uses XCertificateOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $certificateOperation
     * @return XApplicationUserCapfProfile
     */
    public function setCertificateOperation($certificateOperation = 'No Pending Operation')
    {
        // validation for constraint: enumeration
        if (!XCertificateOperation::valueIsValid($certificateOperation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $certificateOperation, implode(', ', XCertificateOperation::getValidValues())), __LINE__);
        }
        $this->certificateOperation = $certificateOperation;
        return $this;
    }
    /**
     * Get authenticationMode value
     * @return string
     */
    public function getAuthenticationMode()
    {
        return $this->authenticationMode;
    }
    /**
     * Set authenticationMode value
     * @uses XAuthenticationMode::valueIsValid()
     * @uses XAuthenticationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $authenticationMode
     * @return XApplicationUserCapfProfile
     */
    public function setAuthenticationMode($authenticationMode = 'By Null String')
    {
        // validation for constraint: enumeration
        if (!XAuthenticationMode::valueIsValid($authenticationMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $authenticationMode, implode(', ', XAuthenticationMode::getValidValues())), __LINE__);
        }
        $this->authenticationMode = $authenticationMode;
        return $this;
    }
    /**
     * Get keySize value
     * @return string
     */
    public function getKeySize()
    {
        return $this->keySize;
    }
    /**
     * Set keySize value
     * @uses XKeySize::valueIsValid()
     * @uses XKeySize::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $keySize
     * @return XApplicationUserCapfProfile
     */
    public function setKeySize($keySize = '1024')
    {
        // validation for constraint: enumeration
        if (!XKeySize::valueIsValid($keySize)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $keySize, implode(', ', XKeySize::getValidValues())), __LINE__);
        }
        $this->keySize = $keySize;
        return $this;
    }
    /**
     * Get authenticationString value
     * @return string|null
     */
    public function getAuthenticationString()
    {
        return $this->authenticationString;
    }
    /**
     * Set authenticationString value
     * @param string $authenticationString
     * @return XApplicationUserCapfProfile
     */
    public function setAuthenticationString($authenticationString = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationString) && !is_string($authenticationString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authenticationString)), __LINE__);
        }
        $this->authenticationString = $authenticationString;
        return $this;
    }
    /**
     * Get operationCompletion value
     * @return string|null
     */
    public function getOperationCompletion()
    {
        return $this->operationCompletion;
    }
    /**
     * Set operationCompletion value
     * @param string $operationCompletion
     * @return XApplicationUserCapfProfile
     */
    public function setOperationCompletion($operationCompletion = null)
    {
        // validation for constraint: string
        if (!is_null($operationCompletion) && !is_string($operationCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationCompletion)), __LINE__);
        }
        $this->operationCompletion = $operationCompletion;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return XApplicationUserCapfProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
