<?php
/**
 * This class stands for XAppOrDeviceReroute EnumType
 * @subpackage Enumerations
 */
class XAppOrDeviceReroute
{
    /**
     * Constant for value 'Redirect to App'
     * @return string 'Redirect to App'
     */
    const VALUE_REDIRECT_TO_APP = 'Redirect to App';
    /**
     * Constant for value 'Redirect to Device'
     * @return string 'Redirect to Device'
     */
    const VALUE_REDIRECT_TO_DEVICE = 'Redirect to Device';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REDIRECT_TO_APP
     * @uses self::VALUE_REDIRECT_TO_DEVICE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REDIRECT_TO_APP,
            self::VALUE_REDIRECT_TO_DEVICE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
