<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCalledPartyTransformationPatternReq StructType
 * @subpackage Structs
 */
class UpdateCalledPartyTransformationPatternReq extends APIRequest
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $pattern;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The dialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $dialPlanName;
    /**
     * The routeFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $routeFilterName;
    /**
     * The newPattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $newPattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $description;
    /**
     * The newRoutePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $newRoutePartitionName;
    /**
     * The calledPartyTransformationMask
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyTransformationMask;
    /**
     * The newDialPlanName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $newDialPlanName;
    /**
     * The digitDiscardInstructionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $digitDiscardInstructionName;
    /**
     * The newRouteFilterName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var XFkType
     */
    public $newRouteFilterName;
    /**
     * The calledPartyPrefixDigits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $calledPartyPrefixDigits;
    /**
     * The calledPartyNumberingPlan
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNumberingPlan;
    /**
     * The calledPartyNumberType
     * Meta informations extracted from the WSDL
     * - default: Cisco CallManager
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $calledPartyNumberType;
    /**
     * Constructor method for UpdateCalledPartyTransformationPatternReq
     * @uses UpdateCalledPartyTransformationPatternReq::setPattern()
     * @uses UpdateCalledPartyTransformationPatternReq::setRoutePartitionName()
     * @uses UpdateCalledPartyTransformationPatternReq::setUuid()
     * @uses UpdateCalledPartyTransformationPatternReq::setDialPlanName()
     * @uses UpdateCalledPartyTransformationPatternReq::setRouteFilterName()
     * @uses UpdateCalledPartyTransformationPatternReq::setNewPattern()
     * @uses UpdateCalledPartyTransformationPatternReq::setDescription()
     * @uses UpdateCalledPartyTransformationPatternReq::setNewRoutePartitionName()
     * @uses UpdateCalledPartyTransformationPatternReq::setCalledPartyTransformationMask()
     * @uses UpdateCalledPartyTransformationPatternReq::setNewDialPlanName()
     * @uses UpdateCalledPartyTransformationPatternReq::setDigitDiscardInstructionName()
     * @uses UpdateCalledPartyTransformationPatternReq::setNewRouteFilterName()
     * @uses UpdateCalledPartyTransformationPatternReq::setCalledPartyPrefixDigits()
     * @uses UpdateCalledPartyTransformationPatternReq::setCalledPartyNumberingPlan()
     * @uses UpdateCalledPartyTransformationPatternReq::setCalledPartyNumberType()
     * @param string $pattern
     * @param XFkType $routePartitionName
     * @param string $uuid
     * @param XFkType $dialPlanName
     * @param XFkType $routeFilterName
     * @param string $newPattern
     * @param string $description
     * @param XFkType $newRoutePartitionName
     * @param string $calledPartyTransformationMask
     * @param XFkType $newDialPlanName
     * @param XFkType $digitDiscardInstructionName
     * @param XFkType $newRouteFilterName
     * @param string $calledPartyPrefixDigits
     * @param string $calledPartyNumberingPlan
     * @param string $calledPartyNumberType
     */
    public function __construct($pattern = null, XFkType $routePartitionName = null, $uuid = null, XFkType $dialPlanName = null, XFkType $routeFilterName = null, $newPattern = null, $description = null, XFkType $newRoutePartitionName = null, $calledPartyTransformationMask = null, XFkType $newDialPlanName = null, XFkType $digitDiscardInstructionName = null, XFkType $newRouteFilterName = null, $calledPartyPrefixDigits = null, $calledPartyNumberingPlan = 'Cisco CallManager', $calledPartyNumberType = 'Cisco CallManager')
    {
        $this
            ->setPattern($pattern)
            ->setRoutePartitionName($routePartitionName)
            ->setUuid($uuid)
            ->setDialPlanName($dialPlanName)
            ->setRouteFilterName($routeFilterName)
            ->setNewPattern($newPattern)
            ->setDescription($description)
            ->setNewRoutePartitionName($newRoutePartitionName)
            ->setCalledPartyTransformationMask($calledPartyTransformationMask)
            ->setNewDialPlanName($newDialPlanName)
            ->setDigitDiscardInstructionName($digitDiscardInstructionName)
            ->setNewRouteFilterName($newRouteFilterName)
            ->setCalledPartyPrefixDigits($calledPartyPrefixDigits)
            ->setCalledPartyNumberingPlan($calledPartyNumberingPlan)
            ->setCalledPartyNumberType($calledPartyNumberType);
    }
    /**
     * Get pattern value
     * @return string
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get dialPlanName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDialPlanName()
    {
        return isset($this->dialPlanName) ? $this->dialPlanName : null;
    }
    /**
     * Set dialPlanName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $dialPlanName
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setDialPlanName(XFkType $dialPlanName = null)
    {
        if (is_null($dialPlanName) || (is_array($dialPlanName) && empty($dialPlanName))) {
            unset($this->dialPlanName);
        } else {
            $this->dialPlanName = $dialPlanName;
        }
        return $this;
    }
    /**
     * Get routeFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getRouteFilterName()
    {
        return isset($this->routeFilterName) ? $this->routeFilterName : null;
    }
    /**
     * Set routeFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $routeFilterName
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setRouteFilterName(XFkType $routeFilterName = null)
    {
        if (is_null($routeFilterName) || (is_array($routeFilterName) && empty($routeFilterName))) {
            unset($this->routeFilterName);
        } else {
            $this->routeFilterName = $routeFilterName;
        }
        return $this;
    }
    /**
     * Get newPattern value
     * @return string|null
     */
    public function getNewPattern()
    {
        return $this->newPattern;
    }
    /**
     * Set newPattern value
     * @param string $newPattern
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setNewPattern($newPattern = null)
    {
        // validation for constraint: string
        if (!is_null($newPattern) && !is_string($newPattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($newPattern)), __LINE__);
        }
        $this->newPattern = $newPattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get newRoutePartitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNewRoutePartitionName()
    {
        return isset($this->newRoutePartitionName) ? $this->newRoutePartitionName : null;
    }
    /**
     * Set newRoutePartitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $newRoutePartitionName
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setNewRoutePartitionName(XFkType $newRoutePartitionName = null)
    {
        if (is_null($newRoutePartitionName) || (is_array($newRoutePartitionName) && empty($newRoutePartitionName))) {
            unset($this->newRoutePartitionName);
        } else {
            $this->newRoutePartitionName = $newRoutePartitionName;
        }
        return $this;
    }
    /**
     * Get calledPartyTransformationMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyTransformationMask()
    {
        return isset($this->calledPartyTransformationMask) ? $this->calledPartyTransformationMask : null;
    }
    /**
     * Set calledPartyTransformationMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyTransformationMask
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setCalledPartyTransformationMask($calledPartyTransformationMask = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyTransformationMask) && !is_string($calledPartyTransformationMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyTransformationMask)), __LINE__);
        }
        if (is_null($calledPartyTransformationMask) || (is_array($calledPartyTransformationMask) && empty($calledPartyTransformationMask))) {
            unset($this->calledPartyTransformationMask);
        } else {
            $this->calledPartyTransformationMask = $calledPartyTransformationMask;
        }
        return $this;
    }
    /**
     * Get newDialPlanName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNewDialPlanName()
    {
        return isset($this->newDialPlanName) ? $this->newDialPlanName : null;
    }
    /**
     * Set newDialPlanName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $newDialPlanName
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setNewDialPlanName(XFkType $newDialPlanName = null)
    {
        if (is_null($newDialPlanName) || (is_array($newDialPlanName) && empty($newDialPlanName))) {
            unset($this->newDialPlanName);
        } else {
            $this->newDialPlanName = $newDialPlanName;
        }
        return $this;
    }
    /**
     * Get digitDiscardInstructionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getDigitDiscardInstructionName()
    {
        return isset($this->digitDiscardInstructionName) ? $this->digitDiscardInstructionName : null;
    }
    /**
     * Set digitDiscardInstructionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $digitDiscardInstructionName
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setDigitDiscardInstructionName(XFkType $digitDiscardInstructionName = null)
    {
        if (is_null($digitDiscardInstructionName) || (is_array($digitDiscardInstructionName) && empty($digitDiscardInstructionName))) {
            unset($this->digitDiscardInstructionName);
        } else {
            $this->digitDiscardInstructionName = $digitDiscardInstructionName;
        }
        return $this;
    }
    /**
     * Get newRouteFilterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return XFkType|null
     */
    public function getNewRouteFilterName()
    {
        return isset($this->newRouteFilterName) ? $this->newRouteFilterName : null;
    }
    /**
     * Set newRouteFilterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param XFkType $newRouteFilterName
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setNewRouteFilterName(XFkType $newRouteFilterName = null)
    {
        if (is_null($newRouteFilterName) || (is_array($newRouteFilterName) && empty($newRouteFilterName))) {
            unset($this->newRouteFilterName);
        } else {
            $this->newRouteFilterName = $newRouteFilterName;
        }
        return $this;
    }
    /**
     * Get calledPartyPrefixDigits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCalledPartyPrefixDigits()
    {
        return isset($this->calledPartyPrefixDigits) ? $this->calledPartyPrefixDigits : null;
    }
    /**
     * Set calledPartyPrefixDigits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $calledPartyPrefixDigits
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setCalledPartyPrefixDigits($calledPartyPrefixDigits = null)
    {
        // validation for constraint: string
        if (!is_null($calledPartyPrefixDigits) && !is_string($calledPartyPrefixDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($calledPartyPrefixDigits)), __LINE__);
        }
        if (is_null($calledPartyPrefixDigits) || (is_array($calledPartyPrefixDigits) && empty($calledPartyPrefixDigits))) {
            unset($this->calledPartyPrefixDigits);
        } else {
            $this->calledPartyPrefixDigits = $calledPartyPrefixDigits;
        }
        return $this;
    }
    /**
     * Get calledPartyNumberingPlan value
     * @return string|null
     */
    public function getCalledPartyNumberingPlan()
    {
        return $this->calledPartyNumberingPlan;
    }
    /**
     * Set calledPartyNumberingPlan value
     * @uses XNumberingPlan::valueIsValid()
     * @uses XNumberingPlan::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberingPlan
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setCalledPartyNumberingPlan($calledPartyNumberingPlan = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XNumberingPlan::valueIsValid($calledPartyNumberingPlan)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberingPlan, implode(', ', XNumberingPlan::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberingPlan = $calledPartyNumberingPlan;
        return $this;
    }
    /**
     * Get calledPartyNumberType value
     * @return string|null
     */
    public function getCalledPartyNumberType()
    {
        return $this->calledPartyNumberType;
    }
    /**
     * Set calledPartyNumberType value
     * @uses XPriOfNumber::valueIsValid()
     * @uses XPriOfNumber::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calledPartyNumberType
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public function setCalledPartyNumberType($calledPartyNumberType = 'Cisco CallManager')
    {
        // validation for constraint: enumeration
        if (!XPriOfNumber::valueIsValid($calledPartyNumberType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $calledPartyNumberType, implode(', ', XPriOfNumber::getValidValues())), __LINE__);
        }
        $this->calledPartyNumberType = $calledPartyNumberType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return UpdateCalledPartyTransformationPatternReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
