<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveDhcpSubnetReq StructType
 * @subpackage Structs
 */
class RemoveDhcpSubnetReq extends AbstractStructBase
{
    /**
     * The dhcpServerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var XFkType
     */
    public $dhcpServerName;
    /**
     * The subnetIpAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $subnetIpAddress;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sequence
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $sequence;
    /**
     * Constructor method for RemoveDhcpSubnetReq
     * @uses RemoveDhcpSubnetReq::setDhcpServerName()
     * @uses RemoveDhcpSubnetReq::setSubnetIpAddress()
     * @uses RemoveDhcpSubnetReq::setUuid()
     * @uses RemoveDhcpSubnetReq::setSequence()
     * @param XFkType $dhcpServerName
     * @param string $subnetIpAddress
     * @param string $uuid
     * @param int $sequence
     */
    public function __construct(XFkType $dhcpServerName = null, $subnetIpAddress = null, $uuid = null, $sequence = null)
    {
        $this
            ->setDhcpServerName($dhcpServerName)
            ->setSubnetIpAddress($subnetIpAddress)
            ->setUuid($uuid)
            ->setSequence($sequence);
    }
    /**
     * Get dhcpServerName value
     * @return XFkType
     */
    public function getDhcpServerName()
    {
        return $this->dhcpServerName;
    }
    /**
     * Set dhcpServerName value
     * @param XFkType $dhcpServerName
     * @return RemoveDhcpSubnetReq
     */
    public function setDhcpServerName(XFkType $dhcpServerName = null)
    {
        $this->dhcpServerName = $dhcpServerName;
        return $this;
    }
    /**
     * Get subnetIpAddress value
     * @return string
     */
    public function getSubnetIpAddress()
    {
        return $this->subnetIpAddress;
    }
    /**
     * Set subnetIpAddress value
     * @param string $subnetIpAddress
     * @return RemoveDhcpSubnetReq
     */
    public function setSubnetIpAddress($subnetIpAddress = null)
    {
        // validation for constraint: string
        if (!is_null($subnetIpAddress) && !is_string($subnetIpAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subnetIpAddress)), __LINE__);
        }
        $this->subnetIpAddress = $subnetIpAddress;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RemoveDhcpSubnetReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get sequence value
     * @return int|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param int $sequence
     * @return RemoveDhcpSubnetReq
     */
    public function setSequence($sequence = null)
    {
        // validation for constraint: int
        if (!is_null($sequence) && !is_numeric($sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sequence)), __LINE__);
        }
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RemoveDhcpSubnetReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
