<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for relatedRegions StructType
 * @subpackage Structs
 */
class RelatedRegions extends AbstractStructBase
{
    /**
     * The relatedRegion
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var XRegionRelationship[]
     */
    public $relatedRegion;
    /**
     * Constructor method for relatedRegions
     * @uses RelatedRegions::setRelatedRegion()
     * @param XRegionRelationship[] $relatedRegion
     */
    public function __construct(array $relatedRegion = array())
    {
        $this
            ->setRelatedRegion($relatedRegion);
    }
    /**
     * Get relatedRegion value
     * @return XRegionRelationship[]|null
     */
    public function getRelatedRegion()
    {
        return $this->relatedRegion;
    }
    /**
     * Set relatedRegion value
     * @throws \InvalidArgumentException
     * @param XRegionRelationship[] $relatedRegion
     * @return RelatedRegions
     */
    public function setRelatedRegion(array $relatedRegion = array())
    {
        foreach ($relatedRegion as $relatedRegionsRelatedRegionItem) {
            // validation for constraint: itemType
            if (!$relatedRegionsRelatedRegionItem instanceof XRegionRelationship) {
                throw new \InvalidArgumentException(sprintf('The relatedRegion property can only contain items of XRegionRelationship, "%s" given', is_object($relatedRegionsRelatedRegionItem) ? get_class($relatedRegionsRelatedRegionItem) : gettype($relatedRegionsRelatedRegionItem)), __LINE__);
            }
        }
        $this->relatedRegion = $relatedRegion;
        return $this;
    }
    /**
     * Add item to relatedRegion value
     * @throws \InvalidArgumentException
     * @param XRegionRelationship $item
     * @return RelatedRegions
     */
    public function addToRelatedRegion(XRegionRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof XRegionRelationship) {
            throw new \InvalidArgumentException(sprintf('The relatedRegion property can only contain items of XRegionRelationship, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relatedRegion[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RelatedRegions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
