<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RServiceProfile StructType
 * @subpackage Structs
 */
class RServiceProfile extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The isDefault
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isDefault;
    /**
     * The serviceProfileInfos
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var ServiceProfileInfos
     */
    public $serviceProfileInfos;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RServiceProfile
     * @uses RServiceProfile::setName()
     * @uses RServiceProfile::setDescription()
     * @uses RServiceProfile::setIsDefault()
     * @uses RServiceProfile::setServiceProfileInfos()
     * @uses RServiceProfile::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isDefault
     * @param ServiceProfileInfos $serviceProfileInfos
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isDefault = null, ServiceProfileInfos $serviceProfileInfos = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsDefault($isDefault)
            ->setServiceProfileInfos($serviceProfileInfos)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RServiceProfile
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RServiceProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isDefault value
     * @return string|null
     */
    public function getIsDefault()
    {
        return $this->isDefault;
    }
    /**
     * Set isDefault value
     * @param string $isDefault
     * @return RServiceProfile
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isDefault) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isDefault, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isDefault) && !is_string($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isDefault)), __LINE__);
        }
        $this->isDefault = $isDefault;
        return $this;
    }
    /**
     * Get serviceProfileInfos value
     * @return ServiceProfileInfos|null
     */
    public function getServiceProfileInfos()
    {
        return $this->serviceProfileInfos;
    }
    /**
     * Set serviceProfileInfos value
     * @param ServiceProfileInfos $serviceProfileInfos
     * @return RServiceProfile
     */
    public function setServiceProfileInfos(ServiceProfileInfos $serviceProfileInfos = null)
    {
        $this->serviceProfileInfos = $serviceProfileInfos;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RServiceProfile
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RServiceProfile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
