<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RSNMPCommunityString StructType
 * @subpackage Structs
 */
class RSNMPCommunityString extends AbstractStructBase
{
    /**
     * The communityName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $communityName;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * The accessPrivilege
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessPrivilege;
    /**
     * The ArrayOfHosts
     * @var RArrayOfHosts
     */
    public $ArrayOfHosts;
    /**
     * Constructor method for RSNMPCommunityString
     * @uses RSNMPCommunityString::setCommunityName()
     * @uses RSNMPCommunityString::setVersion()
     * @uses RSNMPCommunityString::setAccessPrivilege()
     * @uses RSNMPCommunityString::setArrayOfHosts()
     * @param string $communityName
     * @param string $version
     * @param string $accessPrivilege
     * @param RArrayOfHosts $arrayOfHosts
     */
    public function __construct($communityName = null, $version = null, $accessPrivilege = null, RArrayOfHosts $arrayOfHosts = null)
    {
        $this
            ->setCommunityName($communityName)
            ->setVersion($version)
            ->setAccessPrivilege($accessPrivilege)
            ->setArrayOfHosts($arrayOfHosts);
    }
    /**
     * Get communityName value
     * @return string|null
     */
    public function getCommunityName()
    {
        return $this->communityName;
    }
    /**
     * Set communityName value
     * @param string $communityName
     * @return RSNMPCommunityString
     */
    public function setCommunityName($communityName = null)
    {
        // validation for constraint: string
        if (!is_null($communityName) && !is_string($communityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($communityName)), __LINE__);
        }
        $this->communityName = $communityName;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return RSNMPCommunityString
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get accessPrivilege value
     * @return string|null
     */
    public function getAccessPrivilege()
    {
        return $this->accessPrivilege;
    }
    /**
     * Set accessPrivilege value
     * @param string $accessPrivilege
     * @return RSNMPCommunityString
     */
    public function setAccessPrivilege($accessPrivilege = null)
    {
        // validation for constraint: string
        if (!is_null($accessPrivilege) && !is_string($accessPrivilege)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessPrivilege)), __LINE__);
        }
        $this->accessPrivilege = $accessPrivilege;
        return $this;
    }
    /**
     * Get ArrayOfHosts value
     * @return RArrayOfHosts|null
     */
    public function getArrayOfHosts()
    {
        return $this->ArrayOfHosts;
    }
    /**
     * Set ArrayOfHosts value
     * @param RArrayOfHosts $arrayOfHosts
     * @return RSNMPCommunityString
     */
    public function setArrayOfHosts(RArrayOfHosts $arrayOfHosts = null)
    {
        $this->ArrayOfHosts = $arrayOfHosts;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RSNMPCommunityString
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
