<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDeviceMobility StructType
 * @subpackage Structs
 */
class RDeviceMobility extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The subNet
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subNet;
    /**
     * The subNetMaskSz
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $subNetMaskSz;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var Members
     */
    public $members;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RDeviceMobility
     * @uses RDeviceMobility::setName()
     * @uses RDeviceMobility::setSubNet()
     * @uses RDeviceMobility::setSubNetMaskSz()
     * @uses RDeviceMobility::setMembers()
     * @uses RDeviceMobility::setUuid()
     * @param string $name
     * @param string $subNet
     * @param string $subNetMaskSz
     * @param Members $members
     * @param string $uuid
     */
    public function __construct($name = null, $subNet = null, $subNetMaskSz = null, Members $members = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setSubNet($subNet)
            ->setSubNetMaskSz($subNetMaskSz)
            ->setMembers($members)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RDeviceMobility
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get subNet value
     * @return string|null
     */
    public function getSubNet()
    {
        return $this->subNet;
    }
    /**
     * Set subNet value
     * @param string $subNet
     * @return RDeviceMobility
     */
    public function setSubNet($subNet = null)
    {
        // validation for constraint: string
        if (!is_null($subNet) && !is_string($subNet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subNet)), __LINE__);
        }
        $this->subNet = $subNet;
        return $this;
    }
    /**
     * Get subNetMaskSz value
     * @return string|null
     */
    public function getSubNetMaskSz()
    {
        return $this->subNetMaskSz;
    }
    /**
     * Set subNetMaskSz value
     * @uses XInteger::valueIsValid()
     * @uses XInteger::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subNetMaskSz
     * @return RDeviceMobility
     */
    public function setSubNetMaskSz($subNetMaskSz = null)
    {
        // validation for constraint: enumeration
        if (!XInteger::valueIsValid($subNetMaskSz)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $subNetMaskSz, implode(', ', XInteger::getValidValues())), __LINE__);
        }
        $this->subNetMaskSz = $subNetMaskSz;
        return $this;
    }
    /**
     * Get members value
     * @return Members|null
     */
    public function getMembers()
    {
        return $this->members;
    }
    /**
     * Set members value
     * @param Members $members
     * @return RDeviceMobility
     */
    public function setMembers(Members $members = null)
    {
        $this->members = $members;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RDeviceMobility
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RDeviceMobility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
