<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RCcdRequestingService StructType
 * @subpackage Structs
 */
class RCcdRequestingService extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $description;
    /**
     * The isActivated
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $isActivated;
    /**
     * The routePartitionName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $routePartitionName;
    /**
     * The learnedPatternPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $learnedPatternPrefix;
    /**
     * The pstnPrefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $pstnPrefix;
    /**
     * The associatedTrunks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var AssociatedTrunks
     */
    public $associatedTrunks;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for RCcdRequestingService
     * @uses RCcdRequestingService::setName()
     * @uses RCcdRequestingService::setDescription()
     * @uses RCcdRequestingService::setIsActivated()
     * @uses RCcdRequestingService::setRoutePartitionName()
     * @uses RCcdRequestingService::setLearnedPatternPrefix()
     * @uses RCcdRequestingService::setPstnPrefix()
     * @uses RCcdRequestingService::setAssociatedTrunks()
     * @uses RCcdRequestingService::setUuid()
     * @param string $name
     * @param string $description
     * @param string $isActivated
     * @param XFkType $routePartitionName
     * @param string $learnedPatternPrefix
     * @param string $pstnPrefix
     * @param AssociatedTrunks $associatedTrunks
     * @param string $uuid
     */
    public function __construct($name = null, $description = null, $isActivated = null, XFkType $routePartitionName = null, $learnedPatternPrefix = null, $pstnPrefix = null, AssociatedTrunks $associatedTrunks = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setDescription($description)
            ->setIsActivated($isActivated)
            ->setRoutePartitionName($routePartitionName)
            ->setLearnedPatternPrefix($learnedPatternPrefix)
            ->setPstnPrefix($pstnPrefix)
            ->setAssociatedTrunks($associatedTrunks)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return RCcdRequestingService
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return RCcdRequestingService
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get isActivated value
     * @return string|null
     */
    public function getIsActivated()
    {
        return $this->isActivated;
    }
    /**
     * Set isActivated value
     * @param string $isActivated
     * @return RCcdRequestingService
     */
    public function setIsActivated($isActivated = null)
    {
        // validation for constraint: pattern
        if (is_scalar($isActivated) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($isActivated, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($isActivated) && !is_string($isActivated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isActivated)), __LINE__);
        }
        $this->isActivated = $isActivated;
        return $this;
    }
    /**
     * Get routePartitionName value
     * @return XFkType|null
     */
    public function getRoutePartitionName()
    {
        return $this->routePartitionName;
    }
    /**
     * Set routePartitionName value
     * @param XFkType $routePartitionName
     * @return RCcdRequestingService
     */
    public function setRoutePartitionName(XFkType $routePartitionName = null)
    {
        $this->routePartitionName = $routePartitionName;
        return $this;
    }
    /**
     * Get learnedPatternPrefix value
     * @return string|null
     */
    public function getLearnedPatternPrefix()
    {
        return $this->learnedPatternPrefix;
    }
    /**
     * Set learnedPatternPrefix value
     * @param string $learnedPatternPrefix
     * @return RCcdRequestingService
     */
    public function setLearnedPatternPrefix($learnedPatternPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($learnedPatternPrefix) && strlen($learnedPatternPrefix) > 50) || (is_array($learnedPatternPrefix) && count($learnedPatternPrefix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($learnedPatternPrefix) ? strlen($learnedPatternPrefix) : count($learnedPatternPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($learnedPatternPrefix) && !is_string($learnedPatternPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($learnedPatternPrefix)), __LINE__);
        }
        $this->learnedPatternPrefix = $learnedPatternPrefix;
        return $this;
    }
    /**
     * Get pstnPrefix value
     * @return string|null
     */
    public function getPstnPrefix()
    {
        return $this->pstnPrefix;
    }
    /**
     * Set pstnPrefix value
     * @param string $pstnPrefix
     * @return RCcdRequestingService
     */
    public function setPstnPrefix($pstnPrefix = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pstnPrefix) && strlen($pstnPrefix) > 50) || (is_array($pstnPrefix) && count($pstnPrefix) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($pstnPrefix) ? strlen($pstnPrefix) : count($pstnPrefix)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pstnPrefix) && !is_string($pstnPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pstnPrefix)), __LINE__);
        }
        $this->pstnPrefix = $pstnPrefix;
        return $this;
    }
    /**
     * Get associatedTrunks value
     * @return AssociatedTrunks|null
     */
    public function getAssociatedTrunks()
    {
        return $this->associatedTrunks;
    }
    /**
     * Set associatedTrunks value
     * @param AssociatedTrunks $associatedTrunks
     * @return RCcdRequestingService
     */
    public function setAssociatedTrunks(AssociatedTrunks $associatedTrunks = null)
    {
        $this->associatedTrunks = $associatedTrunks;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return RCcdRequestingService
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return RCcdRequestingService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
