<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LLocationRelationship StructType
 * @subpackage Structs
 */
class LLocationRelationship extends AbstractStructBase
{
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $locationName;
    /**
     * The rsvpSetting
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rsvpSetting;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LLocationRelationship
     * @uses LLocationRelationship::setLocationName()
     * @uses LLocationRelationship::setRsvpSetting()
     * @uses LLocationRelationship::setUuid()
     * @param XFkType $locationName
     * @param string $rsvpSetting
     * @param string $uuid
     */
    public function __construct(XFkType $locationName = null, $rsvpSetting = null, $uuid = null)
    {
        $this
            ->setLocationName($locationName)
            ->setRsvpSetting($rsvpSetting)
            ->setUuid($uuid);
    }
    /**
     * Get locationName value
     * @return XFkType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param XFkType $locationName
     * @return LLocationRelationship
     */
    public function setLocationName(XFkType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get rsvpSetting value
     * @return string|null
     */
    public function getRsvpSetting()
    {
        return $this->rsvpSetting;
    }
    /**
     * Set rsvpSetting value
     * @uses XMatrixValue::valueIsValid()
     * @uses XMatrixValue::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rsvpSetting
     * @return LLocationRelationship
     */
    public function setRsvpSetting($rsvpSetting = null)
    {
        // validation for constraint: enumeration
        if (!XMatrixValue::valueIsValid($rsvpSetting)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rsvpSetting, implode(', ', XMatrixValue::getValidValues())), __LINE__);
        }
        $this->rsvpSetting = $rsvpSetting;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LLocationRelationship
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LLocationRelationship
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
