<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LImeExclusionNumber StructType
 * @subpackage Structs
 */
class LImeExclusionNumber extends AbstractStructBase
{
    /**
     * The pattern
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 16
     * @var string
     */
    public $pattern;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The imeExclusionNumberGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $imeExclusionNumberGroupName;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LImeExclusionNumber
     * @uses LImeExclusionNumber::setPattern()
     * @uses LImeExclusionNumber::setDescription()
     * @uses LImeExclusionNumber::setImeExclusionNumberGroupName()
     * @uses LImeExclusionNumber::setUuid()
     * @param string $pattern
     * @param string $description
     * @param XFkType $imeExclusionNumberGroupName
     * @param string $uuid
     */
    public function __construct($pattern = null, $description = null, XFkType $imeExclusionNumberGroupName = null, $uuid = null)
    {
        $this
            ->setPattern($pattern)
            ->setDescription($description)
            ->setImeExclusionNumberGroupName($imeExclusionNumberGroupName)
            ->setUuid($uuid);
    }
    /**
     * Get pattern value
     * @return string|null
     */
    public function getPattern()
    {
        return $this->pattern;
    }
    /**
     * Set pattern value
     * @param string $pattern
     * @return LImeExclusionNumber
     */
    public function setPattern($pattern = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pattern) && strlen($pattern) > 16) || (is_array($pattern) && count($pattern) > 16)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 16 element(s) or a scalar of 16 character(s) at most, "%d" length given', is_scalar($pattern) ? strlen($pattern) : count($pattern)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pattern) && !is_string($pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pattern)), __LINE__);
        }
        $this->pattern = $pattern;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return LImeExclusionNumber
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get imeExclusionNumberGroupName value
     * @return XFkType|null
     */
    public function getImeExclusionNumberGroupName()
    {
        return $this->imeExclusionNumberGroupName;
    }
    /**
     * Set imeExclusionNumberGroupName value
     * @param XFkType $imeExclusionNumberGroupName
     * @return LImeExclusionNumber
     */
    public function setImeExclusionNumberGroupName(XFkType $imeExclusionNumberGroupName = null)
    {
        $this->imeExclusionNumberGroupName = $imeExclusionNumberGroupName;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LImeExclusionNumber
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LImeExclusionNumber
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
