<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LCommonDeviceConfig StructType
 * @subpackage Structs
 */
class LCommonDeviceConfig extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $name;
    /**
     * The softkeyTemplateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var XFkType
     */
    public $softkeyTemplateName;
    /**
     * The userLocale
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userLocale;
    /**
     * The networkHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $networkHoldMohAudioSourceId;
    /**
     * The userHoldMohAudioSourceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userHoldMohAudioSourceId;
    /**
     * The mlppIndicationStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $mlppIndicationStatus;
    /**
     * The useTrustedRelayPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $useTrustedRelayPoint;
    /**
     * The preemption
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $preemption;
    /**
     * The ipAddressingMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddressingMode;
    /**
     * The ipAddressingModePreferenceControl
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ipAddressingModePreferenceControl;
    /**
     * The allowAutoConfigurationForPhones
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $allowAutoConfigurationForPhones;
    /**
     * The useImeForOutboundCalls
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $useImeForOutboundCalls;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - use: optional
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * Constructor method for LCommonDeviceConfig
     * @uses LCommonDeviceConfig::setName()
     * @uses LCommonDeviceConfig::setSoftkeyTemplateName()
     * @uses LCommonDeviceConfig::setUserLocale()
     * @uses LCommonDeviceConfig::setNetworkHoldMohAudioSourceId()
     * @uses LCommonDeviceConfig::setUserHoldMohAudioSourceId()
     * @uses LCommonDeviceConfig::setMlppIndicationStatus()
     * @uses LCommonDeviceConfig::setUseTrustedRelayPoint()
     * @uses LCommonDeviceConfig::setPreemption()
     * @uses LCommonDeviceConfig::setIpAddressingMode()
     * @uses LCommonDeviceConfig::setIpAddressingModePreferenceControl()
     * @uses LCommonDeviceConfig::setAllowAutoConfigurationForPhones()
     * @uses LCommonDeviceConfig::setUseImeForOutboundCalls()
     * @uses LCommonDeviceConfig::setUuid()
     * @param string $name
     * @param XFkType $softkeyTemplateName
     * @param string $userLocale
     * @param string $networkHoldMohAudioSourceId
     * @param string $userHoldMohAudioSourceId
     * @param string $mlppIndicationStatus
     * @param string $useTrustedRelayPoint
     * @param string $preemption
     * @param string $ipAddressingMode
     * @param string $ipAddressingModePreferenceControl
     * @param string $allowAutoConfigurationForPhones
     * @param string $useImeForOutboundCalls
     * @param string $uuid
     */
    public function __construct($name = null, XFkType $softkeyTemplateName = null, $userLocale = null, $networkHoldMohAudioSourceId = null, $userHoldMohAudioSourceId = null, $mlppIndicationStatus = null, $useTrustedRelayPoint = null, $preemption = null, $ipAddressingMode = null, $ipAddressingModePreferenceControl = null, $allowAutoConfigurationForPhones = null, $useImeForOutboundCalls = null, $uuid = null)
    {
        $this
            ->setName($name)
            ->setSoftkeyTemplateName($softkeyTemplateName)
            ->setUserLocale($userLocale)
            ->setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId)
            ->setUserHoldMohAudioSourceId($userHoldMohAudioSourceId)
            ->setMlppIndicationStatus($mlppIndicationStatus)
            ->setUseTrustedRelayPoint($useTrustedRelayPoint)
            ->setPreemption($preemption)
            ->setIpAddressingMode($ipAddressingMode)
            ->setIpAddressingModePreferenceControl($ipAddressingModePreferenceControl)
            ->setAllowAutoConfigurationForPhones($allowAutoConfigurationForPhones)
            ->setUseImeForOutboundCalls($useImeForOutboundCalls)
            ->setUuid($uuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return LCommonDeviceConfig
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 50) || (is_array($name) && count($name) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get softkeyTemplateName value
     * @return XFkType|null
     */
    public function getSoftkeyTemplateName()
    {
        return $this->softkeyTemplateName;
    }
    /**
     * Set softkeyTemplateName value
     * @param XFkType $softkeyTemplateName
     * @return LCommonDeviceConfig
     */
    public function setSoftkeyTemplateName(XFkType $softkeyTemplateName = null)
    {
        $this->softkeyTemplateName = $softkeyTemplateName;
        return $this;
    }
    /**
     * Get userLocale value
     * @return string|null
     */
    public function getUserLocale()
    {
        return $this->userLocale;
    }
    /**
     * Set userLocale value
     * @uses XUserLocale::valueIsValid()
     * @uses XUserLocale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userLocale
     * @return LCommonDeviceConfig
     */
    public function setUserLocale($userLocale = null)
    {
        // validation for constraint: enumeration
        if (!XUserLocale::valueIsValid($userLocale)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userLocale, implode(', ', XUserLocale::getValidValues())), __LINE__);
        }
        $this->userLocale = $userLocale;
        return $this;
    }
    /**
     * Get networkHoldMohAudioSourceId value
     * @return string|null
     */
    public function getNetworkHoldMohAudioSourceId()
    {
        return $this->networkHoldMohAudioSourceId;
    }
    /**
     * Set networkHoldMohAudioSourceId value
     * @uses XMOHAudioSourceId::valueIsValid()
     * @uses XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkHoldMohAudioSourceId
     * @return LCommonDeviceConfig
     */
    public function setNetworkHoldMohAudioSourceId($networkHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!XMOHAudioSourceId::valueIsValid($networkHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkHoldMohAudioSourceId, implode(', ', XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->networkHoldMohAudioSourceId = $networkHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get userHoldMohAudioSourceId value
     * @return string|null
     */
    public function getUserHoldMohAudioSourceId()
    {
        return $this->userHoldMohAudioSourceId;
    }
    /**
     * Set userHoldMohAudioSourceId value
     * @uses XMOHAudioSourceId::valueIsValid()
     * @uses XMOHAudioSourceId::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userHoldMohAudioSourceId
     * @return LCommonDeviceConfig
     */
    public function setUserHoldMohAudioSourceId($userHoldMohAudioSourceId = null)
    {
        // validation for constraint: enumeration
        if (!XMOHAudioSourceId::valueIsValid($userHoldMohAudioSourceId)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userHoldMohAudioSourceId, implode(', ', XMOHAudioSourceId::getValidValues())), __LINE__);
        }
        $this->userHoldMohAudioSourceId = $userHoldMohAudioSourceId;
        return $this;
    }
    /**
     * Get mlppIndicationStatus value
     * @return string|null
     */
    public function getMlppIndicationStatus()
    {
        return $this->mlppIndicationStatus;
    }
    /**
     * Set mlppIndicationStatus value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mlppIndicationStatus
     * @return LCommonDeviceConfig
     */
    public function setMlppIndicationStatus($mlppIndicationStatus = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($mlppIndicationStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mlppIndicationStatus, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->mlppIndicationStatus = $mlppIndicationStatus;
        return $this;
    }
    /**
     * Get useTrustedRelayPoint value
     * @return string|null
     */
    public function getUseTrustedRelayPoint()
    {
        return $this->useTrustedRelayPoint;
    }
    /**
     * Set useTrustedRelayPoint value
     * @param string $useTrustedRelayPoint
     * @return LCommonDeviceConfig
     */
    public function setUseTrustedRelayPoint($useTrustedRelayPoint = null)
    {
        // validation for constraint: pattern
        if (is_scalar($useTrustedRelayPoint) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($useTrustedRelayPoint, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($useTrustedRelayPoint) && !is_string($useTrustedRelayPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($useTrustedRelayPoint)), __LINE__);
        }
        $this->useTrustedRelayPoint = $useTrustedRelayPoint;
        return $this;
    }
    /**
     * Get preemption value
     * @return string|null
     */
    public function getPreemption()
    {
        return $this->preemption;
    }
    /**
     * Set preemption value
     * @uses XPreemption::valueIsValid()
     * @uses XPreemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preemption
     * @return LCommonDeviceConfig
     */
    public function setPreemption($preemption = null)
    {
        // validation for constraint: enumeration
        if (!XPreemption::valueIsValid($preemption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $preemption, implode(', ', XPreemption::getValidValues())), __LINE__);
        }
        $this->preemption = $preemption;
        return $this;
    }
    /**
     * Get ipAddressingMode value
     * @return string|null
     */
    public function getIpAddressingMode()
    {
        return $this->ipAddressingMode;
    }
    /**
     * Set ipAddressingMode value
     * @uses XIPAddressingMode::valueIsValid()
     * @uses XIPAddressingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressingMode
     * @return LCommonDeviceConfig
     */
    public function setIpAddressingMode($ipAddressingMode = null)
    {
        // validation for constraint: enumeration
        if (!XIPAddressingMode::valueIsValid($ipAddressingMode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ipAddressingMode, implode(', ', XIPAddressingMode::getValidValues())), __LINE__);
        }
        $this->ipAddressingMode = $ipAddressingMode;
        return $this;
    }
    /**
     * Get ipAddressingModePreferenceControl value
     * @return string|null
     */
    public function getIpAddressingModePreferenceControl()
    {
        return $this->ipAddressingModePreferenceControl;
    }
    /**
     * Set ipAddressingModePreferenceControl value
     * @uses XIPAddressingModePrefControl::valueIsValid()
     * @uses XIPAddressingModePrefControl::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ipAddressingModePreferenceControl
     * @return LCommonDeviceConfig
     */
    public function setIpAddressingModePreferenceControl($ipAddressingModePreferenceControl = null)
    {
        // validation for constraint: enumeration
        if (!XIPAddressingModePrefControl::valueIsValid($ipAddressingModePreferenceControl)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ipAddressingModePreferenceControl, implode(', ', XIPAddressingModePrefControl::getValidValues())), __LINE__);
        }
        $this->ipAddressingModePreferenceControl = $ipAddressingModePreferenceControl;
        return $this;
    }
    /**
     * Get allowAutoConfigurationForPhones value
     * @return string|null
     */
    public function getAllowAutoConfigurationForPhones()
    {
        return $this->allowAutoConfigurationForPhones;
    }
    /**
     * Set allowAutoConfigurationForPhones value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allowAutoConfigurationForPhones
     * @return LCommonDeviceConfig
     */
    public function setAllowAutoConfigurationForPhones($allowAutoConfigurationForPhones = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($allowAutoConfigurationForPhones)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $allowAutoConfigurationForPhones, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->allowAutoConfigurationForPhones = $allowAutoConfigurationForPhones;
        return $this;
    }
    /**
     * Get useImeForOutboundCalls value
     * @return string|null
     */
    public function getUseImeForOutboundCalls()
    {
        return $this->useImeForOutboundCalls;
    }
    /**
     * Set useImeForOutboundCalls value
     * @uses XStatus::valueIsValid()
     * @uses XStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $useImeForOutboundCalls
     * @return LCommonDeviceConfig
     */
    public function setUseImeForOutboundCalls($useImeForOutboundCalls = null)
    {
        // validation for constraint: enumeration
        if (!XStatus::valueIsValid($useImeForOutboundCalls)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $useImeForOutboundCalls, implode(', ', XStatus::getValidValues())), __LINE__);
        }
        $this->useImeForOutboundCalls = $useImeForOutboundCalls;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return LCommonDeviceConfig
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return LCommonDeviceConfig
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
