<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for isdnNsfInfoElement StructType
 * @subpackage Structs
 */
class IsdnNsfInfoElement extends AbstractStructBase
{
    /**
     * The cic
     * Meta informations extracted from the WSDL
     * - documentation: If not specified then a default value of '0' is set. This tag is not applicable to networkServiceProtocol PRI NI2. | If not specified then a default value of '0' is set. This tag is not applicable to networkServiceProtocol PRI NI2. |
     * If not specified then a default value of '0' is set. This tag is not applicable to networkServiceProtocol PRI NI2.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $cic;
    /**
     * The networkServiceProtocol
     * Meta informations extracted from the WSDL
     * - documentation: It is a mandatory tag if anychild tag of isdnNSFInfoElement is specified. | It is a mandatory tag if anychild tag of isdnNSFInfoElement is specified. | It is a mandatory tag if anychild tag of isdnNSFInfoElement is specified.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkServiceProtocol;
    /**
     * The networkService
     * Meta informations extracted from the WSDL
     * - documentation: If not specified then the first record based on the protocol in NSFProtocolServiceMap table will be set as the default value. | If not specified then the first record based on the protocol in NSFProtocolServiceMap table will be set
     * as the default value. | If not specified then the first record based on the protocol in NSFProtocolServiceMap table will be set as the default value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $networkService;
    /**
     * The paramValue
     * Meta informations extracted from the WSDL
     * - documentation: This parameter will take effect only if the selected network service has a valid parameterName in TypeNSFService. | This parameter will take effect only if the selected network service has a valid parameterName in TypeNSFService. |
     * This parameter will take effect only if the selected network service has a valid parameterName in TypeNSFService.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $paramValue;
    /**
     * Constructor method for isdnNsfInfoElement
     * @uses IsdnNsfInfoElement::setCic()
     * @uses IsdnNsfInfoElement::setNetworkServiceProtocol()
     * @uses IsdnNsfInfoElement::setNetworkService()
     * @uses IsdnNsfInfoElement::setParamValue()
     * @param string $cic
     * @param string $networkServiceProtocol
     * @param string $networkService
     * @param string $paramValue
     */
    public function __construct($cic = null, $networkServiceProtocol = null, $networkService = null, $paramValue = null)
    {
        $this
            ->setCic($cic)
            ->setNetworkServiceProtocol($networkServiceProtocol)
            ->setNetworkService($networkService)
            ->setParamValue($paramValue);
    }
    /**
     * Get cic value
     * @return string|null
     */
    public function getCic()
    {
        return $this->cic;
    }
    /**
     * Set cic value
     * @param string $cic
     * @return IsdnNsfInfoElement
     */
    public function setCic($cic = null)
    {
        // validation for constraint: string
        if (!is_null($cic) && !is_string($cic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cic)), __LINE__);
        }
        $this->cic = $cic;
        return $this;
    }
    /**
     * Get networkServiceProtocol value
     * @return string|null
     */
    public function getNetworkServiceProtocol()
    {
        return $this->networkServiceProtocol;
    }
    /**
     * Set networkServiceProtocol value
     * @uses XPriProtocol::valueIsValid()
     * @uses XPriProtocol::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkServiceProtocol
     * @return IsdnNsfInfoElement
     */
    public function setNetworkServiceProtocol($networkServiceProtocol = null)
    {
        // validation for constraint: enumeration
        if (!XPriProtocol::valueIsValid($networkServiceProtocol)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkServiceProtocol, implode(', ', XPriProtocol::getValidValues())), __LINE__);
        }
        $this->networkServiceProtocol = $networkServiceProtocol;
        return $this;
    }
    /**
     * Get networkService value
     * @return string|null
     */
    public function getNetworkService()
    {
        return $this->networkService;
    }
    /**
     * Set networkService value
     * @uses XNSFService::valueIsValid()
     * @uses XNSFService::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $networkService
     * @return IsdnNsfInfoElement
     */
    public function setNetworkService($networkService = null)
    {
        // validation for constraint: enumeration
        if (!XNSFService::valueIsValid($networkService)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $networkService, implode(', ', XNSFService::getValidValues())), __LINE__);
        }
        $this->networkService = $networkService;
        return $this;
    }
    /**
     * Get paramValue value
     * @return string|null
     */
    public function getParamValue()
    {
        return $this->paramValue;
    }
    /**
     * Set paramValue value
     * @param string $paramValue
     * @return IsdnNsfInfoElement
     */
    public function setParamValue($paramValue = null)
    {
        // validation for constraint: string
        if (!is_null($paramValue) && !is_string($paramValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paramValue)), __LINE__);
        }
        $this->paramValue = $paramValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return IsdnNsfInfoElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
