<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNotificationStatusRes StructType
 * @subpackage Structs
 */
class GetNotificationStatusRes extends APIResponse
{
    /**
     * The objectList
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var RObjectList[]
     */
    public $objectList;
    /**
     * The pollingInterval
     * Meta informations extracted from the WSDL
     * - maxLength: 128
     * @var string
     */
    public $pollingInterval;
    /**
     * The pollingStartTime
     * Meta informations extracted from the WSDL
     * - maxLength: 128
     * @var string
     */
    public $pollingStartTime;
    /**
     * Constructor method for GetNotificationStatusRes
     * @uses GetNotificationStatusRes::setObjectList()
     * @uses GetNotificationStatusRes::setPollingInterval()
     * @uses GetNotificationStatusRes::setPollingStartTime()
     * @param RObjectList[] $objectList
     * @param string $pollingInterval
     * @param string $pollingStartTime
     */
    public function __construct(array $objectList = array(), $pollingInterval = null, $pollingStartTime = null)
    {
        $this
            ->setObjectList($objectList)
            ->setPollingInterval($pollingInterval)
            ->setPollingStartTime($pollingStartTime);
    }
    /**
     * Get objectList value
     * @return RObjectList[]|null
     */
    public function getObjectList()
    {
        return $this->objectList;
    }
    /**
     * Set objectList value
     * @throws \InvalidArgumentException
     * @param RObjectList[] $objectList
     * @return GetNotificationStatusRes
     */
    public function setObjectList(array $objectList = array())
    {
        foreach ($objectList as $getNotificationStatusResObjectListItem) {
            // validation for constraint: itemType
            if (!$getNotificationStatusResObjectListItem instanceof RObjectList) {
                throw new \InvalidArgumentException(sprintf('The objectList property can only contain items of RObjectList, "%s" given', is_object($getNotificationStatusResObjectListItem) ? get_class($getNotificationStatusResObjectListItem) : gettype($getNotificationStatusResObjectListItem)), __LINE__);
            }
        }
        $this->objectList = $objectList;
        return $this;
    }
    /**
     * Add item to objectList value
     * @throws \InvalidArgumentException
     * @param RObjectList $item
     * @return GetNotificationStatusRes
     */
    public function addToObjectList(RObjectList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof RObjectList) {
            throw new \InvalidArgumentException(sprintf('The objectList property can only contain items of RObjectList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->objectList[] = $item;
        return $this;
    }
    /**
     * Get pollingInterval value
     * @return string|null
     */
    public function getPollingInterval()
    {
        return $this->pollingInterval;
    }
    /**
     * Set pollingInterval value
     * @param string $pollingInterval
     * @return GetNotificationStatusRes
     */
    public function setPollingInterval($pollingInterval = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pollingInterval) && strlen($pollingInterval) > 128) || (is_array($pollingInterval) && count($pollingInterval) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($pollingInterval) ? strlen($pollingInterval) : count($pollingInterval)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pollingInterval) && !is_string($pollingInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pollingInterval)), __LINE__);
        }
        $this->pollingInterval = $pollingInterval;
        return $this;
    }
    /**
     * Get pollingStartTime value
     * @return string|null
     */
    public function getPollingStartTime()
    {
        return $this->pollingStartTime;
    }
    /**
     * Set pollingStartTime value
     * @param string $pollingStartTime
     * @return GetNotificationStatusRes
     */
    public function setPollingStartTime($pollingStartTime = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pollingStartTime) && strlen($pollingStartTime) > 128) || (is_array($pollingStartTime) && count($pollingStartTime) > 128)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 128 element(s) or a scalar of 128 character(s) at most, "%d" length given', is_scalar($pollingStartTime) ? strlen($pollingStartTime) : count($pollingStartTime)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pollingStartTime) && !is_string($pollingStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pollingStartTime)), __LINE__);
        }
        $this->pollingStartTime = $pollingStartTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetNotificationStatusRes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
