<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetNotificationChangesRes StructType
 * @subpackage Structs
 */
class GetNotificationChangesRes extends APIResponse
{
    /**
     * The changeNotification
     * Meta informations extracted from the WSDL
     * - documentation: Tag would contain an xml with all change notifications for Registered object.
     * - minOccurs: 0
     * - nillable: true
     * @var RNotificationChange
     */
    public $changeNotification;
    /**
     * The pollingInterval
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $pollingInterval;
    /**
     * The pollingStartTime
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $pollingStartTime;
    /**
     * Constructor method for GetNotificationChangesRes
     * @uses GetNotificationChangesRes::setChangeNotification()
     * @uses GetNotificationChangesRes::setPollingInterval()
     * @uses GetNotificationChangesRes::setPollingStartTime()
     * @param RNotificationChange $changeNotification
     * @param string $pollingInterval
     * @param string $pollingStartTime
     */
    public function __construct(RNotificationChange $changeNotification = null, $pollingInterval = null, $pollingStartTime = null)
    {
        $this
            ->setChangeNotification($changeNotification)
            ->setPollingInterval($pollingInterval)
            ->setPollingStartTime($pollingStartTime);
    }
    /**
     * Get changeNotification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return RNotificationChange|null
     */
    public function getChangeNotification()
    {
        return isset($this->changeNotification) ? $this->changeNotification : null;
    }
    /**
     * Set changeNotification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param RNotificationChange $changeNotification
     * @return GetNotificationChangesRes
     */
    public function setChangeNotification(RNotificationChange $changeNotification = null)
    {
        if (is_null($changeNotification) || (is_array($changeNotification) && empty($changeNotification))) {
            unset($this->changeNotification);
        } else {
            $this->changeNotification = $changeNotification;
        }
        return $this;
    }
    /**
     * Get pollingInterval value
     * @return string|null
     */
    public function getPollingInterval()
    {
        return $this->pollingInterval;
    }
    /**
     * Set pollingInterval value
     * @param string $pollingInterval
     * @return GetNotificationChangesRes
     */
    public function setPollingInterval($pollingInterval = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pollingInterval) && strlen($pollingInterval) > 32) || (is_array($pollingInterval) && count($pollingInterval) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($pollingInterval) ? strlen($pollingInterval) : count($pollingInterval)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pollingInterval) && !is_string($pollingInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pollingInterval)), __LINE__);
        }
        $this->pollingInterval = $pollingInterval;
        return $this;
    }
    /**
     * Get pollingStartTime value
     * @return string|null
     */
    public function getPollingStartTime()
    {
        return $this->pollingStartTime;
    }
    /**
     * Set pollingStartTime value
     * @param string $pollingStartTime
     * @return GetNotificationChangesRes
     */
    public function setPollingStartTime($pollingStartTime = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pollingStartTime) && strlen($pollingStartTime) > 32) || (is_array($pollingStartTime) && count($pollingStartTime) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($pollingStartTime) ? strlen($pollingStartTime) : count($pollingStartTime)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pollingStartTime) && !is_string($pollingStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pollingStartTime)), __LINE__);
        }
        $this->pollingStartTime = $pollingStartTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return GetNotificationChangesRes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
