<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoNotificationRegisterReq StructType
 * @subpackage Structs
 */
class DoNotificationRegisterReq extends APIRequest
{
    /**
     * The networkId
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $networkId;
    /**
     * The clientName
     * Meta informations extracted from the WSDL
     * - maxLength: 32
     * @var string
     */
    public $clientName;
    /**
     * Constructor method for DoNotificationRegisterReq
     * @uses DoNotificationRegisterReq::setNetworkId()
     * @uses DoNotificationRegisterReq::setClientName()
     * @param string $networkId
     * @param string $clientName
     */
    public function __construct($networkId = null, $clientName = null)
    {
        $this
            ->setNetworkId($networkId)
            ->setClientName($clientName);
    }
    /**
     * Get networkId value
     * @return string|null
     */
    public function getNetworkId()
    {
        return $this->networkId;
    }
    /**
     * Set networkId value
     * @param string $networkId
     * @return DoNotificationRegisterReq
     */
    public function setNetworkId($networkId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($networkId) && strlen($networkId) > 32) || (is_array($networkId) && count($networkId) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($networkId) ? strlen($networkId) : count($networkId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($networkId) && !is_string($networkId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($networkId)), __LINE__);
        }
        $this->networkId = $networkId;
        return $this;
    }
    /**
     * Get clientName value
     * @return string|null
     */
    public function getClientName()
    {
        return $this->clientName;
    }
    /**
     * Set clientName value
     * @param string $clientName
     * @return DoNotificationRegisterReq
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clientName) && strlen($clientName) > 32) || (is_array($clientName) && count($clientName) > 32)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 32 element(s) or a scalar of 32 character(s) at most, "%d" length given', is_scalar($clientName) ? strlen($clientName) : count($clientName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientName)), __LINE__);
        }
        $this->clientName = $clientName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DoNotificationRegisterReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
