<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoLdapSyncReq StructType
 * Meta informations extracted from the WSDL
 * - documentation: Initiates the sync
 * @subpackage Structs
 */
class DoLdapSyncReq extends APIRequest
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: The Config Name of the Ldap Directory.
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - nillable: false
     * - pattern: \{........-....-....-....-............\}
     * @var string
     */
    public $uuid;
    /**
     * The sync
     * Meta informations extracted from the WSDL
     * - documentation: True means start sync, false means cancel the sync which is currently under process
     * - nillable: false
     * - pattern: (t)|(f)|(true)|(false)|(0)|(1)
     * @var string
     */
    public $sync;
    /**
     * Constructor method for DoLdapSyncReq
     * @uses DoLdapSyncReq::setName()
     * @uses DoLdapSyncReq::setUuid()
     * @uses DoLdapSyncReq::setSync()
     * @param string $name
     * @param string $uuid
     * @param string $sync
     */
    public function __construct($name = null, $uuid = null, $sync = null)
    {
        $this
            ->setName($name)
            ->setUuid($uuid)
            ->setSync($sync);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return DoLdapSyncReq
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return DoLdapSyncReq
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uuid) && !preg_match('/\{........-....-....-....-............\}/', $uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\{........-....-....-....-............\}", "%s" given', var_export($uuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get sync value
     * @return string|null
     */
    public function getSync()
    {
        return $this->sync;
    }
    /**
     * Set sync value
     * @param string $sync
     * @return DoLdapSyncReq
     */
    public function setSync($sync = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sync) && !preg_match('/(t)|(f)|(true)|(false)|(0)|(1)/', $sync)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(t)|(f)|(true)|(false)|(0)|(1)", "%s" given', var_export($sync, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sync) && !is_string($sync)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sync)), __LINE__);
        }
        $this->sync = $sync;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return DoLdapSyncReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
