<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for applications StructType
 * @subpackage Structs
 */
class Applications extends AbstractStructBase
{
    /**
     * The application
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 50
     * @var string[]
     */
    public $application;
    /**
     * Constructor method for applications
     * @uses Applications::setApplication()
     * @param string[] $application
     */
    public function __construct(array $application = array())
    {
        $this
            ->setApplication($application);
    }
    /**
     * Get application value
     * @return string[]|null
     */
    public function getApplication()
    {
        return $this->application;
    }
    /**
     * Set application value
     * @throws \InvalidArgumentException
     * @param string[] $application
     * @return Applications
     */
    public function setApplication(array $application = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($application) && strlen($application) > 50) || (is_array($application) && count($application) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($application) ? strlen($application) : count($application)), __LINE__);
        }
        foreach ($application as $applicationsApplicationItem) {
            // validation for constraint: itemType
            if (!is_string($applicationsApplicationItem)) {
                throw new \InvalidArgumentException(sprintf('The application property can only contain items of string, "%s" given', is_object($applicationsApplicationItem) ? get_class($applicationsApplicationItem) : gettype($applicationsApplicationItem)), __LINE__);
            }
        }
        $this->application = $application;
        return $this;
    }
    /**
     * Add item to application value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return Applications
     */
    public function addToApplication($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 50) || (is_array($item) && count($item) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The application property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->application[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return Applications
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
