<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateProfile StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValidateProfile
 * @subpackage Structs
 */
class ValidateProfile extends TransactionInfo
{
    /**
     * The ValidateProfileRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ValidateProfile
     */
    public $ValidateProfileRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The UserNameInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\UserNameInfo
     */
    public $UserNameInfo;
    /**
     * The EmailAddressInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\EmailAddressInfo
     */
    public $EmailAddressInfo;
    /**
     * The PasswordInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\PasswordInfo
     */
    public $PasswordInfo;
    /**
     * The ActivateProfile
     * @var bool
     */
    public $ActivateProfile;
    /**
     * Constructor method for ValidateProfile
     * @uses ValidateProfile::setValidateProfileRequest()
     * @uses ValidateProfile::setActionType()
     * @uses ValidateProfile::setUserNameInfo()
     * @uses ValidateProfile::setEmailAddressInfo()
     * @uses ValidateProfile::setPasswordInfo()
     * @uses ValidateProfile::setActivateProfile()
     * @param \StructType\ValidateProfile $validateProfileRequest
     * @param string $actionType
     * @param \StructType\UserNameInfo $userNameInfo
     * @param \StructType\EmailAddressInfo $emailAddressInfo
     * @param \StructType\PasswordInfo $passwordInfo
     * @param bool $activateProfile
     */
    public function __construct(\StructType\ValidateProfile $validateProfileRequest = null, $actionType = null, \StructType\UserNameInfo $userNameInfo = null, \StructType\EmailAddressInfo $emailAddressInfo = null, \StructType\PasswordInfo $passwordInfo = null, $activateProfile = null)
    {
        $this
            ->setValidateProfileRequest($validateProfileRequest)
            ->setActionType($actionType)
            ->setUserNameInfo($userNameInfo)
            ->setEmailAddressInfo($emailAddressInfo)
            ->setPasswordInfo($passwordInfo)
            ->setActivateProfile($activateProfile);
    }
    /**
     * Get ValidateProfileRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ValidateProfile|null
     */
    public function getValidateProfileRequest()
    {
        return isset($this->ValidateProfileRequest) ? $this->ValidateProfileRequest : null;
    }
    /**
     * Set ValidateProfileRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ValidateProfile $validateProfileRequest
     * @return \StructType\ValidateProfile
     */
    public function setValidateProfileRequest(\StructType\ValidateProfile $validateProfileRequest = null)
    {
        if (is_null($validateProfileRequest) || (is_array($validateProfileRequest) && empty($validateProfileRequest))) {
            unset($this->ValidateProfileRequest);
        } else {
            $this->ValidateProfileRequest = $validateProfileRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\ValidateProfile_ActionTypes::valueIsValid()
     * @uses \EnumType\ValidateProfile_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\ValidateProfile
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ValidateProfile_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ValidateProfile_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\ValidateProfile_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get UserNameInfo value
     * @return \StructType\UserNameInfo|null
     */
    public function getUserNameInfo()
    {
        return $this->UserNameInfo;
    }
    /**
     * Set UserNameInfo value
     * @param \StructType\UserNameInfo $userNameInfo
     * @return \StructType\ValidateProfile
     */
    public function setUserNameInfo(\StructType\UserNameInfo $userNameInfo = null)
    {
        $this->UserNameInfo = $userNameInfo;
        return $this;
    }
    /**
     * Get EmailAddressInfo value
     * @return \StructType\EmailAddressInfo|null
     */
    public function getEmailAddressInfo()
    {
        return $this->EmailAddressInfo;
    }
    /**
     * Set EmailAddressInfo value
     * @param \StructType\EmailAddressInfo $emailAddressInfo
     * @return \StructType\ValidateProfile
     */
    public function setEmailAddressInfo(\StructType\EmailAddressInfo $emailAddressInfo = null)
    {
        $this->EmailAddressInfo = $emailAddressInfo;
        return $this;
    }
    /**
     * Get PasswordInfo value
     * @return \StructType\PasswordInfo|null
     */
    public function getPasswordInfo()
    {
        return $this->PasswordInfo;
    }
    /**
     * Set PasswordInfo value
     * @param \StructType\PasswordInfo $passwordInfo
     * @return \StructType\ValidateProfile
     */
    public function setPasswordInfo(\StructType\PasswordInfo $passwordInfo = null)
    {
        $this->PasswordInfo = $passwordInfo;
        return $this;
    }
    /**
     * Get ActivateProfile value
     * @return bool|null
     */
    public function getActivateProfile()
    {
        return $this->ActivateProfile;
    }
    /**
     * Set ActivateProfile value
     * @param bool $activateProfile
     * @return \StructType\ValidateProfile
     */
    public function setActivateProfile($activateProfile = null)
    {
        // validation for constraint: boolean
        if (!is_null($activateProfile) && !is_bool($activateProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activateProfile, true), gettype($activateProfile)), __LINE__);
        }
        $this->ActivateProfile = $activateProfile;
        return $this;
    }
}
