<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Retrieve ServiceType
 * @subpackage Services
 */
class Retrieve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RetrieveProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveProfile $parameters
     * @return \StructType\RetrieveProfileResponse|bool
     */
    public function RetrieveProfile(\StructType\RetrieveProfile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveProfileReservations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveProfileReservations $parameters
     * @return \StructType\RetrieveProfileReservationsResponse|bool
     */
    public function RetrieveProfileReservations(\StructType\RetrieveProfileReservations $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveProfileReservations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RetrieveProfileVouchers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RetrieveProfileVouchers $parameters
     * @return \StructType\RetrieveProfileVouchersResponse|bool
     */
    public function RetrieveProfileVouchers(\StructType\RetrieveProfileVouchers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RetrieveProfileVouchers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RetrieveProfileReservationsResponse|\StructType\RetrieveProfileResponse|\StructType\RetrieveProfileVouchersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
