<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveProfileReservation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveProfileReservation
 * @subpackage Structs
 */
class RetrieveProfileReservation extends AbstractStructBase
{
    /**
     * The SeriesNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesNumber;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The PrimaryPassengerLastname
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryPassengerLastname;
    /**
     * The NumPassengers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumPassengers;
    /**
     * The FirstSectorOrigin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstSectorOrigin;
    /**
     * The FirstSectorDestination
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstSectorDestination;
    /**
     * The BookingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BookingDate;
    /**
     * The FirstSectorDepartureDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FirstSectorDepartureDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for RetrieveProfileReservation
     * @uses RetrieveProfileReservation::setSeriesNumber()
     * @uses RetrieveProfileReservation::setConfirmationNumber()
     * @uses RetrieveProfileReservation::setPrimaryPassengerLastname()
     * @uses RetrieveProfileReservation::setNumPassengers()
     * @uses RetrieveProfileReservation::setFirstSectorOrigin()
     * @uses RetrieveProfileReservation::setFirstSectorDestination()
     * @uses RetrieveProfileReservation::setBookingDate()
     * @uses RetrieveProfileReservation::setFirstSectorDepartureDate()
     * @uses RetrieveProfileReservation::setStatus()
     * @param string $seriesNumber
     * @param string $confirmationNumber
     * @param string $primaryPassengerLastname
     * @param int $numPassengers
     * @param string $firstSectorOrigin
     * @param string $firstSectorDestination
     * @param string $bookingDate
     * @param string $firstSectorDepartureDate
     * @param string $status
     */
    public function __construct($seriesNumber = null, $confirmationNumber = null, $primaryPassengerLastname = null, $numPassengers = null, $firstSectorOrigin = null, $firstSectorDestination = null, $bookingDate = null, $firstSectorDepartureDate = null, $status = null)
    {
        $this
            ->setSeriesNumber($seriesNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setPrimaryPassengerLastname($primaryPassengerLastname)
            ->setNumPassengers($numPassengers)
            ->setFirstSectorOrigin($firstSectorOrigin)
            ->setFirstSectorDestination($firstSectorDestination)
            ->setBookingDate($bookingDate)
            ->setFirstSectorDepartureDate($firstSectorDepartureDate)
            ->setStatus($status);
    }
    /**
     * Get SeriesNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesNumber()
    {
        return isset($this->SeriesNumber) ? $this->SeriesNumber : null;
    }
    /**
     * Set SeriesNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesNumber
     * @return \StructType\RetrieveProfileReservation
     */
    public function setSeriesNumber($seriesNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seriesNumber) && !is_string($seriesNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesNumber, true), gettype($seriesNumber)), __LINE__);
        }
        if (is_null($seriesNumber) || (is_array($seriesNumber) && empty($seriesNumber))) {
            unset($this->SeriesNumber);
        } else {
            $this->SeriesNumber = $seriesNumber;
        }
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return isset($this->ConfirmationNumber) ? $this->ConfirmationNumber : null;
    }
    /**
     * Set ConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNumber
     * @return \StructType\RetrieveProfileReservation
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        if (is_null($confirmationNumber) || (is_array($confirmationNumber) && empty($confirmationNumber))) {
            unset($this->ConfirmationNumber);
        } else {
            $this->ConfirmationNumber = $confirmationNumber;
        }
        return $this;
    }
    /**
     * Get PrimaryPassengerLastname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryPassengerLastname()
    {
        return isset($this->PrimaryPassengerLastname) ? $this->PrimaryPassengerLastname : null;
    }
    /**
     * Set PrimaryPassengerLastname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryPassengerLastname
     * @return \StructType\RetrieveProfileReservation
     */
    public function setPrimaryPassengerLastname($primaryPassengerLastname = null)
    {
        // validation for constraint: string
        if (!is_null($primaryPassengerLastname) && !is_string($primaryPassengerLastname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryPassengerLastname, true), gettype($primaryPassengerLastname)), __LINE__);
        }
        if (is_null($primaryPassengerLastname) || (is_array($primaryPassengerLastname) && empty($primaryPassengerLastname))) {
            unset($this->PrimaryPassengerLastname);
        } else {
            $this->PrimaryPassengerLastname = $primaryPassengerLastname;
        }
        return $this;
    }
    /**
     * Get NumPassengers value
     * @return int|null
     */
    public function getNumPassengers()
    {
        return $this->NumPassengers;
    }
    /**
     * Set NumPassengers value
     * @param int $numPassengers
     * @return \StructType\RetrieveProfileReservation
     */
    public function setNumPassengers($numPassengers = null)
    {
        // validation for constraint: int
        if (!is_null($numPassengers) && !(is_int($numPassengers) || ctype_digit($numPassengers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numPassengers, true), gettype($numPassengers)), __LINE__);
        }
        $this->NumPassengers = $numPassengers;
        return $this;
    }
    /**
     * Get FirstSectorOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstSectorOrigin()
    {
        return isset($this->FirstSectorOrigin) ? $this->FirstSectorOrigin : null;
    }
    /**
     * Set FirstSectorOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstSectorOrigin
     * @return \StructType\RetrieveProfileReservation
     */
    public function setFirstSectorOrigin($firstSectorOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($firstSectorOrigin) && !is_string($firstSectorOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstSectorOrigin, true), gettype($firstSectorOrigin)), __LINE__);
        }
        if (is_null($firstSectorOrigin) || (is_array($firstSectorOrigin) && empty($firstSectorOrigin))) {
            unset($this->FirstSectorOrigin);
        } else {
            $this->FirstSectorOrigin = $firstSectorOrigin;
        }
        return $this;
    }
    /**
     * Get FirstSectorDestination value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstSectorDestination()
    {
        return isset($this->FirstSectorDestination) ? $this->FirstSectorDestination : null;
    }
    /**
     * Set FirstSectorDestination value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstSectorDestination
     * @return \StructType\RetrieveProfileReservation
     */
    public function setFirstSectorDestination($firstSectorDestination = null)
    {
        // validation for constraint: string
        if (!is_null($firstSectorDestination) && !is_string($firstSectorDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstSectorDestination, true), gettype($firstSectorDestination)), __LINE__);
        }
        if (is_null($firstSectorDestination) || (is_array($firstSectorDestination) && empty($firstSectorDestination))) {
            unset($this->FirstSectorDestination);
        } else {
            $this->FirstSectorDestination = $firstSectorDestination;
        }
        return $this;
    }
    /**
     * Get BookingDate value
     * @return string|null
     */
    public function getBookingDate()
    {
        return $this->BookingDate;
    }
    /**
     * Set BookingDate value
     * @param string $bookingDate
     * @return \StructType\RetrieveProfileReservation
     */
    public function setBookingDate($bookingDate = null)
    {
        // validation for constraint: string
        if (!is_null($bookingDate) && !is_string($bookingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingDate, true), gettype($bookingDate)), __LINE__);
        }
        $this->BookingDate = $bookingDate;
        return $this;
    }
    /**
     * Get FirstSectorDepartureDate value
     * @return string|null
     */
    public function getFirstSectorDepartureDate()
    {
        return $this->FirstSectorDepartureDate;
    }
    /**
     * Set FirstSectorDepartureDate value
     * @param string $firstSectorDepartureDate
     * @return \StructType\RetrieveProfileReservation
     */
    public function setFirstSectorDepartureDate($firstSectorDepartureDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstSectorDepartureDate) && !is_string($firstSectorDepartureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstSectorDepartureDate, true), gettype($firstSectorDepartureDate)), __LINE__);
        }
        $this->FirstSectorDepartureDate = $firstSectorDepartureDate;
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\RetrieveProfileReservation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
