<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveProfile StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveProfile
 * @subpackage Structs
 */
class RetrieveProfile extends TransactionInfo
{
    /**
     * The RetrieveProfileRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RetrieveProfile
     */
    public $RetrieveProfileRequest;
    /**
     * The ActionType
     * @var string
     */
    public $ActionType;
    /**
     * The PasswordInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\PasswordInfo
     */
    public $PasswordInfo;
    /**
     * The EmailAddressInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\EmailAddressInfo
     */
    public $EmailAddressInfo;
    /**
     * The UserNameInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\UserNameInfo
     */
    public $UserNameInfo;
    /**
     * The StaffIDInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\StaffIDInfo
     */
    public $StaffIDInfo;
    /**
     * Constructor method for RetrieveProfile
     * @uses RetrieveProfile::setRetrieveProfileRequest()
     * @uses RetrieveProfile::setActionType()
     * @uses RetrieveProfile::setPasswordInfo()
     * @uses RetrieveProfile::setEmailAddressInfo()
     * @uses RetrieveProfile::setUserNameInfo()
     * @uses RetrieveProfile::setStaffIDInfo()
     * @param \StructType\RetrieveProfile $retrieveProfileRequest
     * @param string $actionType
     * @param \StructType\PasswordInfo $passwordInfo
     * @param \StructType\EmailAddressInfo $emailAddressInfo
     * @param \StructType\UserNameInfo $userNameInfo
     * @param \StructType\StaffIDInfo $staffIDInfo
     */
    public function __construct(\StructType\RetrieveProfile $retrieveProfileRequest = null, $actionType = null, \StructType\PasswordInfo $passwordInfo = null, \StructType\EmailAddressInfo $emailAddressInfo = null, \StructType\UserNameInfo $userNameInfo = null, \StructType\StaffIDInfo $staffIDInfo = null)
    {
        $this
            ->setRetrieveProfileRequest($retrieveProfileRequest)
            ->setActionType($actionType)
            ->setPasswordInfo($passwordInfo)
            ->setEmailAddressInfo($emailAddressInfo)
            ->setUserNameInfo($userNameInfo)
            ->setStaffIDInfo($staffIDInfo);
    }
    /**
     * Get RetrieveProfileRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RetrieveProfile|null
     */
    public function getRetrieveProfileRequest()
    {
        return isset($this->RetrieveProfileRequest) ? $this->RetrieveProfileRequest : null;
    }
    /**
     * Set RetrieveProfileRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RetrieveProfile $retrieveProfileRequest
     * @return \StructType\RetrieveProfile
     */
    public function setRetrieveProfileRequest(\StructType\RetrieveProfile $retrieveProfileRequest = null)
    {
        if (is_null($retrieveProfileRequest) || (is_array($retrieveProfileRequest) && empty($retrieveProfileRequest))) {
            unset($this->RetrieveProfileRequest);
        } else {
            $this->RetrieveProfileRequest = $retrieveProfileRequest;
        }
        return $this;
    }
    /**
     * Get ActionType value
     * @return string|null
     */
    public function getActionType()
    {
        return $this->ActionType;
    }
    /**
     * Set ActionType value
     * @uses \EnumType\RetrieveProfile_ActionTypes::valueIsValid()
     * @uses \EnumType\RetrieveProfile_ActionTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \StructType\RetrieveProfile
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RetrieveProfile_ActionTypes::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RetrieveProfile_ActionTypes', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \EnumType\RetrieveProfile_ActionTypes::getValidValues())), __LINE__);
        }
        $this->ActionType = $actionType;
        return $this;
    }
    /**
     * Get PasswordInfo value
     * @return \StructType\PasswordInfo|null
     */
    public function getPasswordInfo()
    {
        return $this->PasswordInfo;
    }
    /**
     * Set PasswordInfo value
     * @param \StructType\PasswordInfo $passwordInfo
     * @return \StructType\RetrieveProfile
     */
    public function setPasswordInfo(\StructType\PasswordInfo $passwordInfo = null)
    {
        $this->PasswordInfo = $passwordInfo;
        return $this;
    }
    /**
     * Get EmailAddressInfo value
     * @return \StructType\EmailAddressInfo|null
     */
    public function getEmailAddressInfo()
    {
        return $this->EmailAddressInfo;
    }
    /**
     * Set EmailAddressInfo value
     * @param \StructType\EmailAddressInfo $emailAddressInfo
     * @return \StructType\RetrieveProfile
     */
    public function setEmailAddressInfo(\StructType\EmailAddressInfo $emailAddressInfo = null)
    {
        $this->EmailAddressInfo = $emailAddressInfo;
        return $this;
    }
    /**
     * Get UserNameInfo value
     * @return \StructType\UserNameInfo|null
     */
    public function getUserNameInfo()
    {
        return $this->UserNameInfo;
    }
    /**
     * Set UserNameInfo value
     * @param \StructType\UserNameInfo $userNameInfo
     * @return \StructType\RetrieveProfile
     */
    public function setUserNameInfo(\StructType\UserNameInfo $userNameInfo = null)
    {
        $this->UserNameInfo = $userNameInfo;
        return $this;
    }
    /**
     * Get StaffIDInfo value
     * @return \StructType\StaffIDInfo|null
     */
    public function getStaffIDInfo()
    {
        return $this->StaffIDInfo;
    }
    /**
     * Set StaffIDInfo value
     * @param \StructType\StaffIDInfo $staffIDInfo
     * @return \StructType\RetrieveProfile
     */
    public function setStaffIDInfo(\StructType\StaffIDInfo $staffIDInfo = null)
    {
        $this->StaffIDInfo = $staffIDInfo;
        return $this;
    }
}
