<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Preference StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Preference
 * @subpackage Structs
 */
class Preference extends AbstractStructBase
{
    /**
     * The PreferenceID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PreferenceID;
    /**
     * The PreferenceTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PreferenceTypeID;
    /**
     * The PreferenceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferenceName;
    /**
     * The PreferenceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferenceValue;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for Preference
     * @uses Preference::setPreferenceID()
     * @uses Preference::setPreferenceTypeID()
     * @uses Preference::setPreferenceName()
     * @uses Preference::setPreferenceValue()
     * @uses Preference::setCreateDate()
     * @uses Preference::setActive()
     * @param int $preferenceID
     * @param int $preferenceTypeID
     * @param string $preferenceName
     * @param string $preferenceValue
     * @param string $createDate
     * @param bool $active
     */
    public function __construct($preferenceID = null, $preferenceTypeID = null, $preferenceName = null, $preferenceValue = null, $createDate = null, $active = null)
    {
        $this
            ->setPreferenceID($preferenceID)
            ->setPreferenceTypeID($preferenceTypeID)
            ->setPreferenceName($preferenceName)
            ->setPreferenceValue($preferenceValue)
            ->setCreateDate($createDate)
            ->setActive($active);
    }
    /**
     * Get PreferenceID value
     * @return int|null
     */
    public function getPreferenceID()
    {
        return $this->PreferenceID;
    }
    /**
     * Set PreferenceID value
     * @param int $preferenceID
     * @return \StructType\Preference
     */
    public function setPreferenceID($preferenceID = null)
    {
        // validation for constraint: int
        if (!is_null($preferenceID) && !(is_int($preferenceID) || ctype_digit($preferenceID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preferenceID, true), gettype($preferenceID)), __LINE__);
        }
        $this->PreferenceID = $preferenceID;
        return $this;
    }
    /**
     * Get PreferenceTypeID value
     * @return int|null
     */
    public function getPreferenceTypeID()
    {
        return $this->PreferenceTypeID;
    }
    /**
     * Set PreferenceTypeID value
     * @param int $preferenceTypeID
     * @return \StructType\Preference
     */
    public function setPreferenceTypeID($preferenceTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($preferenceTypeID) && !(is_int($preferenceTypeID) || ctype_digit($preferenceTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preferenceTypeID, true), gettype($preferenceTypeID)), __LINE__);
        }
        $this->PreferenceTypeID = $preferenceTypeID;
        return $this;
    }
    /**
     * Get PreferenceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferenceName()
    {
        return isset($this->PreferenceName) ? $this->PreferenceName : null;
    }
    /**
     * Set PreferenceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferenceName
     * @return \StructType\Preference
     */
    public function setPreferenceName($preferenceName = null)
    {
        // validation for constraint: string
        if (!is_null($preferenceName) && !is_string($preferenceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferenceName, true), gettype($preferenceName)), __LINE__);
        }
        if (is_null($preferenceName) || (is_array($preferenceName) && empty($preferenceName))) {
            unset($this->PreferenceName);
        } else {
            $this->PreferenceName = $preferenceName;
        }
        return $this;
    }
    /**
     * Get PreferenceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferenceValue()
    {
        return isset($this->PreferenceValue) ? $this->PreferenceValue : null;
    }
    /**
     * Set PreferenceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferenceValue
     * @return \StructType\Preference
     */
    public function setPreferenceValue($preferenceValue = null)
    {
        // validation for constraint: string
        if (!is_null($preferenceValue) && !is_string($preferenceValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferenceValue, true), gettype($preferenceValue)), __LINE__);
        }
        if (is_null($preferenceValue) || (is_array($preferenceValue) && empty($preferenceValue))) {
            unset($this->PreferenceValue);
        } else {
            $this->PreferenceValue = $preferenceValue;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Preference
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Preference
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
}
