<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Payment
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The PaymentID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentID;
    /**
     * The PaymentTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentTypeID;
    /**
     * The PaymentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentName;
    /**
     * The CardHolderName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardHolderName;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for Payment
     * @uses Payment::setPaymentID()
     * @uses Payment::setPaymentTypeID()
     * @uses Payment::setPaymentName()
     * @uses Payment::setCardHolderName()
     * @uses Payment::setAccountNumber()
     * @uses Payment::setExpirationDate()
     * @uses Payment::setCreateDate()
     * @uses Payment::setActive()
     * @param int $paymentID
     * @param int $paymentTypeID
     * @param string $paymentName
     * @param string $cardHolderName
     * @param string $accountNumber
     * @param string $expirationDate
     * @param string $createDate
     * @param bool $active
     */
    public function __construct($paymentID = null, $paymentTypeID = null, $paymentName = null, $cardHolderName = null, $accountNumber = null, $expirationDate = null, $createDate = null, $active = null)
    {
        $this
            ->setPaymentID($paymentID)
            ->setPaymentTypeID($paymentTypeID)
            ->setPaymentName($paymentName)
            ->setCardHolderName($cardHolderName)
            ->setAccountNumber($accountNumber)
            ->setExpirationDate($expirationDate)
            ->setCreateDate($createDate)
            ->setActive($active);
    }
    /**
     * Get PaymentID value
     * @return int|null
     */
    public function getPaymentID()
    {
        return $this->PaymentID;
    }
    /**
     * Set PaymentID value
     * @param int $paymentID
     * @return \StructType\Payment
     */
    public function setPaymentID($paymentID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentID) && !(is_int($paymentID) || ctype_digit($paymentID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentID, true), gettype($paymentID)), __LINE__);
        }
        $this->PaymentID = $paymentID;
        return $this;
    }
    /**
     * Get PaymentTypeID value
     * @return int|null
     */
    public function getPaymentTypeID()
    {
        return $this->PaymentTypeID;
    }
    /**
     * Set PaymentTypeID value
     * @param int $paymentTypeID
     * @return \StructType\Payment
     */
    public function setPaymentTypeID($paymentTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTypeID) && !(is_int($paymentTypeID) || ctype_digit($paymentTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentTypeID, true), gettype($paymentTypeID)), __LINE__);
        }
        $this->PaymentTypeID = $paymentTypeID;
        return $this;
    }
    /**
     * Get PaymentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentName()
    {
        return isset($this->PaymentName) ? $this->PaymentName : null;
    }
    /**
     * Set PaymentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentName
     * @return \StructType\Payment
     */
    public function setPaymentName($paymentName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentName) && !is_string($paymentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentName, true), gettype($paymentName)), __LINE__);
        }
        if (is_null($paymentName) || (is_array($paymentName) && empty($paymentName))) {
            unset($this->PaymentName);
        } else {
            $this->PaymentName = $paymentName;
        }
        return $this;
    }
    /**
     * Get CardHolderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardHolderName()
    {
        return isset($this->CardHolderName) ? $this->CardHolderName : null;
    }
    /**
     * Set CardHolderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardHolderName
     * @return \StructType\Payment
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderName, true), gettype($cardHolderName)), __LINE__);
        }
        if (is_null($cardHolderName) || (is_array($cardHolderName) && empty($cardHolderName))) {
            unset($this->CardHolderName);
        } else {
            $this->CardHolderName = $cardHolderName;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \StructType\Payment
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\Payment
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Payment
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Payment
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
}
