<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifyProfilePassword StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifyProfilePassword
 * @subpackage Structs
 */
class ModifyProfilePassword extends TransactionInfo
{
    /**
     * The ModifyProfilePasswordRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ModifyProfilePassword
     */
    public $ModifyProfilePasswordRequest;
    /**
     * The ProfileId
     * @var int
     */
    public $ProfileId;
    /**
     * The PasswordInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\PasswordInfo
     */
    public $PasswordInfo;
    /**
     * The NewPasswordInfo
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\NewPasswordInfo
     */
    public $NewPasswordInfo;
    /**
     * The ActionSuccessful
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ActionSuccessful;
    /**
     * The Exceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExceptionInformation_Exceptions
     */
    public $Exceptions;
    /**
     * Constructor method for ModifyProfilePassword
     * @uses ModifyProfilePassword::setModifyProfilePasswordRequest()
     * @uses ModifyProfilePassword::setProfileId()
     * @uses ModifyProfilePassword::setPasswordInfo()
     * @uses ModifyProfilePassword::setNewPasswordInfo()
     * @uses ModifyProfilePassword::setActionSuccessful()
     * @uses ModifyProfilePassword::setExceptions()
     * @param \StructType\ModifyProfilePassword $modifyProfilePasswordRequest
     * @param int $profileId
     * @param \StructType\PasswordInfo $passwordInfo
     * @param \StructType\NewPasswordInfo $newPasswordInfo
     * @param bool $actionSuccessful
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     */
    public function __construct(\StructType\ModifyProfilePassword $modifyProfilePasswordRequest = null, $profileId = null, \StructType\PasswordInfo $passwordInfo = null, \StructType\NewPasswordInfo $newPasswordInfo = null, $actionSuccessful = null, \StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        $this
            ->setModifyProfilePasswordRequest($modifyProfilePasswordRequest)
            ->setProfileId($profileId)
            ->setPasswordInfo($passwordInfo)
            ->setNewPasswordInfo($newPasswordInfo)
            ->setActionSuccessful($actionSuccessful)
            ->setExceptions($exceptions);
    }
    /**
     * Get ModifyProfilePasswordRequest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ModifyProfilePassword|null
     */
    public function getModifyProfilePasswordRequest()
    {
        return isset($this->ModifyProfilePasswordRequest) ? $this->ModifyProfilePasswordRequest : null;
    }
    /**
     * Set ModifyProfilePasswordRequest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ModifyProfilePassword $modifyProfilePasswordRequest
     * @return \StructType\ModifyProfilePassword
     */
    public function setModifyProfilePasswordRequest(\StructType\ModifyProfilePassword $modifyProfilePasswordRequest = null)
    {
        if (is_null($modifyProfilePasswordRequest) || (is_array($modifyProfilePasswordRequest) && empty($modifyProfilePasswordRequest))) {
            unset($this->ModifyProfilePasswordRequest);
        } else {
            $this->ModifyProfilePasswordRequest = $modifyProfilePasswordRequest;
        }
        return $this;
    }
    /**
     * Get ProfileId value
     * @return int|null
     */
    public function getProfileId()
    {
        return $this->ProfileId;
    }
    /**
     * Set ProfileId value
     * @param int $profileId
     * @return \StructType\ModifyProfilePassword
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: int
        if (!is_null($profileId) && !(is_int($profileId) || ctype_digit($profileId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        $this->ProfileId = $profileId;
        return $this;
    }
    /**
     * Get PasswordInfo value
     * @return \StructType\PasswordInfo|null
     */
    public function getPasswordInfo()
    {
        return $this->PasswordInfo;
    }
    /**
     * Set PasswordInfo value
     * @param \StructType\PasswordInfo $passwordInfo
     * @return \StructType\ModifyProfilePassword
     */
    public function setPasswordInfo(\StructType\PasswordInfo $passwordInfo = null)
    {
        $this->PasswordInfo = $passwordInfo;
        return $this;
    }
    /**
     * Get NewPasswordInfo value
     * @return \StructType\NewPasswordInfo|null
     */
    public function getNewPasswordInfo()
    {
        return $this->NewPasswordInfo;
    }
    /**
     * Set NewPasswordInfo value
     * @param \StructType\NewPasswordInfo $newPasswordInfo
     * @return \StructType\ModifyProfilePassword
     */
    public function setNewPasswordInfo(\StructType\NewPasswordInfo $newPasswordInfo = null)
    {
        $this->NewPasswordInfo = $newPasswordInfo;
        return $this;
    }
    /**
     * Get ActionSuccessful value
     * @return bool|null
     */
    public function getActionSuccessful()
    {
        return $this->ActionSuccessful;
    }
    /**
     * Set ActionSuccessful value
     * @param bool $actionSuccessful
     * @return \StructType\ModifyProfilePassword
     */
    public function setActionSuccessful($actionSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($actionSuccessful) && !is_bool($actionSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($actionSuccessful, true), gettype($actionSuccessful)), __LINE__);
        }
        $this->ActionSuccessful = $actionSuccessful;
        return $this;
    }
    /**
     * Get Exceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExceptionInformation_Exceptions|null
     */
    public function getExceptions()
    {
        return isset($this->Exceptions) ? $this->Exceptions : null;
    }
    /**
     * Set Exceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExceptionInformation_Exceptions $exceptions
     * @return \StructType\ModifyProfilePassword
     */
    public function setExceptions(\StructType\ExceptionInformation_Exceptions $exceptions = null)
    {
        if (is_null($exceptions) || (is_array($exceptions) && empty($exceptions))) {
            unset($this->Exceptions);
        } else {
            $this->Exceptions = $exceptions;
        }
        return $this;
    }
}
