<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Identification StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Identification
 * @subpackage Structs
 */
class Identification extends AbstractStructBase
{
    /**
     * The IdentificationID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdentificationID;
    /**
     * The IdentificationTypeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdentificationTypeID;
    /**
     * The IdentificationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentificationName;
    /**
     * The IdentificationValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentificationValue;
    /**
     * The IdentificationInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentificationInfo;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The IssueAgency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssueAgency;
    /**
     * The IssuePlace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IssuePlace;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationDate;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreateDate;
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * Constructor method for Identification
     * @uses Identification::setIdentificationID()
     * @uses Identification::setIdentificationTypeID()
     * @uses Identification::setIdentificationName()
     * @uses Identification::setIdentificationValue()
     * @uses Identification::setIdentificationInfo()
     * @uses Identification::setIssueDate()
     * @uses Identification::setIssueAgency()
     * @uses Identification::setIssuePlace()
     * @uses Identification::setExpirationDate()
     * @uses Identification::setCreateDate()
     * @uses Identification::setActive()
     * @param int $identificationID
     * @param int $identificationTypeID
     * @param string $identificationName
     * @param string $identificationValue
     * @param string $identificationInfo
     * @param string $issueDate
     * @param string $issueAgency
     * @param string $issuePlace
     * @param string $expirationDate
     * @param string $createDate
     * @param bool $active
     */
    public function __construct($identificationID = null, $identificationTypeID = null, $identificationName = null, $identificationValue = null, $identificationInfo = null, $issueDate = null, $issueAgency = null, $issuePlace = null, $expirationDate = null, $createDate = null, $active = null)
    {
        $this
            ->setIdentificationID($identificationID)
            ->setIdentificationTypeID($identificationTypeID)
            ->setIdentificationName($identificationName)
            ->setIdentificationValue($identificationValue)
            ->setIdentificationInfo($identificationInfo)
            ->setIssueDate($issueDate)
            ->setIssueAgency($issueAgency)
            ->setIssuePlace($issuePlace)
            ->setExpirationDate($expirationDate)
            ->setCreateDate($createDate)
            ->setActive($active);
    }
    /**
     * Get IdentificationID value
     * @return int|null
     */
    public function getIdentificationID()
    {
        return $this->IdentificationID;
    }
    /**
     * Set IdentificationID value
     * @param int $identificationID
     * @return \StructType\Identification
     */
    public function setIdentificationID($identificationID = null)
    {
        // validation for constraint: int
        if (!is_null($identificationID) && !(is_int($identificationID) || ctype_digit($identificationID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($identificationID, true), gettype($identificationID)), __LINE__);
        }
        $this->IdentificationID = $identificationID;
        return $this;
    }
    /**
     * Get IdentificationTypeID value
     * @return int|null
     */
    public function getIdentificationTypeID()
    {
        return $this->IdentificationTypeID;
    }
    /**
     * Set IdentificationTypeID value
     * @param int $identificationTypeID
     * @return \StructType\Identification
     */
    public function setIdentificationTypeID($identificationTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($identificationTypeID) && !(is_int($identificationTypeID) || ctype_digit($identificationTypeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($identificationTypeID, true), gettype($identificationTypeID)), __LINE__);
        }
        $this->IdentificationTypeID = $identificationTypeID;
        return $this;
    }
    /**
     * Get IdentificationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificationName()
    {
        return isset($this->IdentificationName) ? $this->IdentificationName : null;
    }
    /**
     * Set IdentificationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificationName
     * @return \StructType\Identification
     */
    public function setIdentificationName($identificationName = null)
    {
        // validation for constraint: string
        if (!is_null($identificationName) && !is_string($identificationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationName, true), gettype($identificationName)), __LINE__);
        }
        if (is_null($identificationName) || (is_array($identificationName) && empty($identificationName))) {
            unset($this->IdentificationName);
        } else {
            $this->IdentificationName = $identificationName;
        }
        return $this;
    }
    /**
     * Get IdentificationValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificationValue()
    {
        return isset($this->IdentificationValue) ? $this->IdentificationValue : null;
    }
    /**
     * Set IdentificationValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificationValue
     * @return \StructType\Identification
     */
    public function setIdentificationValue($identificationValue = null)
    {
        // validation for constraint: string
        if (!is_null($identificationValue) && !is_string($identificationValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationValue, true), gettype($identificationValue)), __LINE__);
        }
        if (is_null($identificationValue) || (is_array($identificationValue) && empty($identificationValue))) {
            unset($this->IdentificationValue);
        } else {
            $this->IdentificationValue = $identificationValue;
        }
        return $this;
    }
    /**
     * Get IdentificationInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificationInfo()
    {
        return isset($this->IdentificationInfo) ? $this->IdentificationInfo : null;
    }
    /**
     * Set IdentificationInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificationInfo
     * @return \StructType\Identification
     */
    public function setIdentificationInfo($identificationInfo = null)
    {
        // validation for constraint: string
        if (!is_null($identificationInfo) && !is_string($identificationInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationInfo, true), gettype($identificationInfo)), __LINE__);
        }
        if (is_null($identificationInfo) || (is_array($identificationInfo) && empty($identificationInfo))) {
            unset($this->IdentificationInfo);
        } else {
            $this->IdentificationInfo = $identificationInfo;
        }
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\Identification
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssueAgency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssueAgency()
    {
        return isset($this->IssueAgency) ? $this->IssueAgency : null;
    }
    /**
     * Set IssueAgency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issueAgency
     * @return \StructType\Identification
     */
    public function setIssueAgency($issueAgency = null)
    {
        // validation for constraint: string
        if (!is_null($issueAgency) && !is_string($issueAgency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueAgency, true), gettype($issueAgency)), __LINE__);
        }
        if (is_null($issueAgency) || (is_array($issueAgency) && empty($issueAgency))) {
            unset($this->IssueAgency);
        } else {
            $this->IssueAgency = $issueAgency;
        }
        return $this;
    }
    /**
     * Get IssuePlace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIssuePlace()
    {
        return isset($this->IssuePlace) ? $this->IssuePlace : null;
    }
    /**
     * Set IssuePlace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $issuePlace
     * @return \StructType\Identification
     */
    public function setIssuePlace($issuePlace = null)
    {
        // validation for constraint: string
        if (!is_null($issuePlace) && !is_string($issuePlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuePlace, true), gettype($issuePlace)), __LINE__);
        }
        if (is_null($issuePlace) || (is_array($issuePlace) && empty($issuePlace))) {
            unset($this->IssuePlace);
        } else {
            $this->IssuePlace = $issuePlace;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * @return string|null
     */
    public function getExpirationDate()
    {
        return $this->ExpirationDate;
    }
    /**
     * Set ExpirationDate value
     * @param string $expirationDate
     * @return \StructType\Identification
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        $this->ExpirationDate = $expirationDate;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\Identification
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Identification
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
}
